/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.common.util.AbstractBigArray;

public final class BigDoubleArrayList
extends AbstractBigArray {
    private static final int DEFAULT_PAGE_SIZE = 2048;
    private double[][] pages;

    public BigDoubleArrayList(int pageSize, long initialCapacity) {
        super(pageSize, null, true);
        this.pages = new double[this.numPages(initialCapacity)][];
    }

    public BigDoubleArrayList(long initialCapacity) {
        this(2048, initialCapacity);
    }

    public BigDoubleArrayList() {
        this(1024L);
    }

    public double get(long index) {
        assert (index >= 0L && index < this.size);
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    public void add(double d) {
        int pageIndex = this.pageIndex(this.size);
        if (pageIndex >= this.pages.length) {
            int newLength = ArrayUtil.oversize((int)(pageIndex + 1), (int)this.numBytesPerElement());
            this.pages = (double[][])Arrays.copyOf(this.pages, newLength);
        }
        if (this.pages[pageIndex] == null) {
            this.pages[pageIndex] = new double[this.pageSize()];
        }
        int indexInPage = this.indexInPage(this.size);
        this.pages[pageIndex][indexInPage] = d;
        ++this.size;
    }

    @Override
    protected int numBytesPerElement() {
        return 8;
    }
}

