/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;

public class GeoShapeFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private final ShapeBuilder shape;
    private SpatialStrategy strategy = null;
    private Boolean cache;
    private String cacheKey;
    private String filterName;
    private final String indexedShapeId;
    private final String indexedShapeType;
    private String indexedShapeIndex;
    private String indexedShapePath;
    private ShapeRelation relation = null;

    public GeoShapeFilterBuilder(String name, ShapeBuilder shape) {
        this(name, shape, null, null, null);
    }

    public GeoShapeFilterBuilder(String name, ShapeBuilder shape, ShapeRelation relation) {
        this(name, shape, null, null, relation);
    }

    public GeoShapeFilterBuilder(String name, String indexedShapeId, String indexedShapeType, ShapeRelation relation) {
        this(name, null, indexedShapeId, indexedShapeType, relation);
    }

    private GeoShapeFilterBuilder(String name, ShapeBuilder shape, String indexedShapeId, String indexedShapeType, ShapeRelation relation) {
        this.name = name;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.relation = relation;
        this.indexedShapeType = indexedShapeType;
    }

    public GeoShapeFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public GeoShapeFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public GeoShapeFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public GeoShapeFilterBuilder strategy(SpatialStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public GeoShapeFilterBuilder indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return this;
    }

    public GeoShapeFilterBuilder indexedShapePath(String indexedShapePath) {
        this.indexedShapePath = indexedShapePath;
        return this;
    }

    public GeoShapeFilterBuilder relation(ShapeRelation relation) {
        this.relation = relation;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_shape");
        builder.startObject(this.name);
        if (this.strategy != null) {
            builder.field("strategy", this.strategy.getStrategyName());
        }
        if (this.shape != null) {
            builder.field("shape", this.shape);
        } else {
            builder.startObject("indexed_shape").field("id", this.indexedShapeId).field("type", this.indexedShapeType);
            if (this.indexedShapeIndex != null) {
                builder.field("index", this.indexedShapeIndex);
            }
            if (this.indexedShapePath != null) {
                builder.field("path", this.indexedShapePath);
            }
            builder.endObject();
        }
        if (this.relation != null) {
            builder.field("relation", this.relation.getRelationName());
        }
        builder.endObject();
        if (this.name != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }
}

