/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.termvector;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.termvector.MultiTermVectorsRequest;
import org.elasticsearch.action.termvector.MultiTermVectorsResponse;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.rest.action.termvector.RestTermVectorAction;

public class RestMultiTermVectorsAction
extends BaseRestHandler {
    @Inject
    public RestMultiTermVectorsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mtermvectors", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_mtermvectors", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        MultiTermVectorsRequest multiTermVectorsRequest = new MultiTermVectorsRequest();
        multiTermVectorsRequest.listenerThreaded(false);
        TermVectorRequest template = new TermVectorRequest();
        template.index(request.param("index"));
        template.type(request.param("type"));
        RestTermVectorAction.readURIParameters(template, request);
        multiTermVectorsRequest.ids(Strings.commaDelimitedListToStringArray(request.param("ids")));
        try {
            multiTermVectorsRequest.add(template, RestActions.getRestContent(request));
        }
        catch (Throwable t) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, t));
            }
            catch (Throwable tIO) {
                this.logger.error("Failed to send failure response", tIO, new Object[0]);
            }
            return;
        }
        this.client.multiTermVectors(multiTermVectorsRequest, new ActionListener<MultiTermVectorsResponse>(){

            @Override
            public void onResponse(MultiTermVectorsResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    response.toXContent(builder, request);
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable t) {
                    this.onFailure(t);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (Throwable t) {
                    RestMultiTermVectorsAction.this.logger.error("Failed to send failure response", t, new Object[0]);
                }
            }
        });
    }
}

