/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.stats.extended;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValueSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.numeric.NumericValuesSource;

public class ExtendedStatsAggregator
extends MetricsAggregator.MultiValue {
    private final NumericValuesSource valuesSource;
    private LongArray counts;
    private DoubleArray sums;
    private DoubleArray mins;
    private DoubleArray maxes;
    private DoubleArray sumOfSqrs;

    public ExtendedStatsAggregator(String name, long estimatedBucketsCount, NumericValuesSource valuesSource, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.counts = BigArrays.newLongArray(initialSize, context.pageCacheRecycler(), true);
            this.sums = BigArrays.newDoubleArray(initialSize, context.pageCacheRecycler(), true);
            this.mins = BigArrays.newDoubleArray(initialSize, context.pageCacheRecycler(), false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
            this.maxes = BigArrays.newDoubleArray(initialSize, context.pageCacheRecycler(), false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
            this.sumOfSqrs = BigArrays.newDoubleArray(initialSize, context.pageCacheRecycler(), true);
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (this.valuesSource != null) : "collect must only be called if #shouldCollect returns true";
        DoubleValues values = this.valuesSource.doubleValues();
        if (values == null) {
            return;
        }
        if (owningBucketOrdinal >= this.counts.size()) {
            long from = this.counts.size();
            long overSize = BigArrays.overSize(owningBucketOrdinal + 1L);
            this.counts = BigArrays.resize(this.counts, overSize);
            this.sums = BigArrays.resize(this.sums, overSize);
            this.mins = BigArrays.resize(this.mins, overSize);
            this.maxes = BigArrays.resize(this.maxes, overSize);
            this.sumOfSqrs = BigArrays.resize(this.sumOfSqrs, overSize);
            this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
            this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
        }
        int valuesCount = values.setDocument(doc);
        this.counts.increment(owningBucketOrdinal, valuesCount);
        double sum = 0.0;
        double sumOfSqr = 0.0;
        double min = this.mins.get(owningBucketOrdinal);
        double max = this.maxes.get(owningBucketOrdinal);
        for (int i = 0; i < valuesCount; ++i) {
            double value = values.nextValue();
            sum += value;
            sumOfSqr += value * value;
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        this.sums.increment(owningBucketOrdinal, sum);
        this.sumOfSqrs.increment(owningBucketOrdinal, sumOfSqr);
        this.mins.set(owningBucketOrdinal, min);
        this.maxes.set(owningBucketOrdinal, max);
    }

    @Override
    public boolean hasMetric(String name) {
        try {
            InternalExtendedStats.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        switch (InternalExtendedStats.Metrics.resolve(name)) {
            case count: {
                return this.valuesSource == null ? 0.0 : (double)this.counts.get(owningBucketOrd);
            }
            case sum: {
                return this.valuesSource == null ? 0.0 : this.sums.get(owningBucketOrd);
            }
            case min: {
                return this.valuesSource == null ? Double.POSITIVE_INFINITY : this.mins.get(owningBucketOrd);
            }
            case max: {
                return this.valuesSource == null ? Double.NEGATIVE_INFINITY : this.maxes.get(owningBucketOrd);
            }
            case avg: {
                return this.valuesSource == null ? Double.NaN : this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            }
            case sum_of_squares: {
                return this.valuesSource == null ? 0.0 : this.sumOfSqrs.get(owningBucketOrd);
            }
            case variance: {
                return this.valuesSource == null ? Double.NaN : this.variance(owningBucketOrd);
            }
            case std_deviation: {
                return this.valuesSource == null ? Double.NaN : Math.sqrt(this.variance(owningBucketOrd));
            }
        }
        throw new ElasticsearchIllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    private double variance(long owningBucketOrd) {
        double sum = this.sums.get(owningBucketOrd);
        long count = this.counts.get(owningBucketOrd);
        return (this.sumOfSqrs.get(owningBucketOrd) - sum * sum / (double)count) / (double)count;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalExtendedStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0);
        }
        assert (owningBucketOrdinal < this.counts.size());
        return new InternalExtendedStats(this.name, this.counts.get(owningBucketOrdinal), this.sums.get(owningBucketOrdinal), this.mins.get(owningBucketOrdinal), this.maxes.get(owningBucketOrdinal), this.sumOfSqrs.get(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalExtendedStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0);
    }

    @Override
    public void doRelease() {
        Releasables.release(this.counts, this.maxes, this.mins, this.sumOfSqrs, this.sums);
    }

    public static class Factory
    extends ValueSourceAggregatorFactory.LeafOnly<NumericValuesSource> {
        public Factory(String name, ValuesSourceConfig<NumericValuesSource> valuesSourceConfig) {
            super(name, InternalExtendedStats.TYPE.name(), valuesSourceConfig);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new ExtendedStatsAggregator(this.name, 0L, null, aggregationContext, parent);
        }

        @Override
        protected Aggregator create(NumericValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new ExtendedStatsAggregator(this.name, expectedBucketsCount, valuesSource, aggregationContext, parent);
        }
    }
}

