/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.collect.HppcMaps;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hppc.IntArrayList;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.controller.ScoreDocQueue;
import org.elasticsearch.search.controller.ShardFieldDocSortedHitQueue;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.InternalFacets;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.FetchSearchResultProvider;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.InternalSearchHits;
import org.elasticsearch.search.internal.InternalSearchResponse;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.search.suggest.Suggest;

public class SearchPhaseController
extends AbstractComponent {
    public static Comparator<AtomicArray.Entry<? extends QuerySearchResultProvider>> QUERY_RESULT_ORDERING = new Comparator<AtomicArray.Entry<? extends QuerySearchResultProvider>>(){

        @Override
        public int compare(AtomicArray.Entry<? extends QuerySearchResultProvider> o1, AtomicArray.Entry<? extends QuerySearchResultProvider> o2) {
            int i = ((QuerySearchResultProvider)o1.value).shardTarget().index().compareTo(((QuerySearchResultProvider)o2.value).shardTarget().index());
            if (i == 0) {
                i = ((QuerySearchResultProvider)o1.value).shardTarget().shardId() - ((QuerySearchResultProvider)o2.value).shardTarget().shardId();
            }
            return i;
        }
    };
    public static final ScoreDoc[] EMPTY_DOCS = new ScoreDoc[0];
    private final CacheRecycler cacheRecycler;
    private final boolean optimizeSingleShard;

    @Inject
    public SearchPhaseController(Settings settings, CacheRecycler cacheRecycler) {
        super(settings);
        this.cacheRecycler = cacheRecycler;
        this.optimizeSingleShard = this.componentSettings.getAsBoolean("optimize_single_shard", (Boolean)true);
    }

    public boolean optimizeSingleShard() {
        return this.optimizeSingleShard;
    }

    public AggregatedDfs aggregateDfs(AtomicArray<DfsSearchResult> results) {
        ObjectObjectOpenHashMap<Term, TermStatistics> termStatistics = HppcMaps.newNoNullKeysMap();
        ObjectObjectOpenHashMap<String, CollectionStatistics> fieldStatistics = HppcMaps.newNoNullKeysMap();
        long aggMaxDoc = 0L;
        for (AtomicArray.Entry<DfsSearchResult> lEntry : results.asList()) {
            Term[] terms = ((DfsSearchResult)lEntry.value).terms();
            TermStatistics[] stats = ((DfsSearchResult)lEntry.value).termStatistics();
            assert (terms.length == stats.length);
            for (int i = 0; i < terms.length; ++i) {
                assert (terms[i] != null);
                TermStatistics existing = termStatistics.get(terms[i]);
                if (existing != null) {
                    assert (terms[i].bytes().equals((Object)existing.term()));
                    termStatistics.put(terms[i], new TermStatistics(existing.term(), existing.docFreq() + stats[i].docFreq(), SearchPhaseController.optionalSum(existing.totalTermFreq(), stats[i].totalTermFreq())));
                    continue;
                }
                termStatistics.put(terms[i], stats[i]);
            }
            boolean[] states = ((DfsSearchResult)lEntry.value).fieldStatistics().allocated;
            KType[] keys = ((DfsSearchResult)lEntry.value).fieldStatistics().keys;
            VType[] values = ((DfsSearchResult)lEntry.value).fieldStatistics().values;
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                String key = (String)keys[i];
                CollectionStatistics value = (CollectionStatistics)values[i];
                assert (key != null);
                CollectionStatistics existing = fieldStatistics.get(key);
                if (existing != null) {
                    CollectionStatistics merged = new CollectionStatistics(key, existing.maxDoc() + value.maxDoc(), SearchPhaseController.optionalSum(existing.docCount(), value.docCount()), SearchPhaseController.optionalSum(existing.sumTotalTermFreq(), value.sumTotalTermFreq()), SearchPhaseController.optionalSum(existing.sumDocFreq(), value.sumDocFreq()));
                    fieldStatistics.put(key, merged);
                    continue;
                }
                fieldStatistics.put(key, value);
            }
            aggMaxDoc += (long)((DfsSearchResult)lEntry.value).maxDoc();
        }
        return new AggregatedDfs(termStatistics, fieldStatistics, aggMaxDoc);
    }

    private static long optionalSum(long left, long right) {
        return Math.min(left, right) == -1L ? -1L : left + right;
    }

    public ScoreDoc[] sortDocs(AtomicArray<? extends QuerySearchResultProvider> resultsArr) {
        PriorityQueue queue;
        List<AtomicArray.Entry<? extends QuerySearchResultProvider>> results = resultsArr.asList();
        if (results.isEmpty()) {
            return EMPTY_DOCS;
        }
        if (this.optimizeSingleShard) {
            boolean canOptimize = false;
            QuerySearchResult result = null;
            int shardIndex = -1;
            if (results.size() == 1) {
                canOptimize = true;
                result = ((QuerySearchResultProvider)results.get((int)0).value).queryResult();
                shardIndex = results.get((int)0).index;
            } else {
                for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : results) {
                    if (((QuerySearchResultProvider)entry.value).queryResult().topDocs().scoreDocs.length <= 0) continue;
                    if (result != null) {
                        canOptimize = false;
                        break;
                    }
                    canOptimize = true;
                    result = ((QuerySearchResultProvider)entry.value).queryResult();
                    shardIndex = entry.index;
                }
            }
            if (canOptimize) {
                ScoreDoc[] scoreDocs = result.topDocs().scoreDocs;
                if (scoreDocs.length < result.from()) {
                    return EMPTY_DOCS;
                }
                int resultDocsSize = result.size();
                if (scoreDocs.length - result.from() < resultDocsSize) {
                    resultDocsSize = scoreDocs.length - result.from();
                }
                if (result.topDocs() instanceof TopFieldDocs) {
                    ScoreDoc[] docs = new ScoreDoc[resultDocsSize];
                    for (int i = 0; i < resultDocsSize; ++i) {
                        ScoreDoc scoreDoc = scoreDocs[result.from() + i];
                        scoreDoc.shardIndex = shardIndex;
                        docs[i] = scoreDoc;
                    }
                    return docs;
                }
                ScoreDoc[] docs = new ScoreDoc[resultDocsSize];
                for (int i = 0; i < resultDocsSize; ++i) {
                    ScoreDoc scoreDoc = scoreDocs[result.from() + i];
                    scoreDoc.shardIndex = shardIndex;
                    docs[i] = scoreDoc;
                }
                return docs;
            }
        }
        AtomicArray.Entry[] sortedResults = results.toArray(new AtomicArray.Entry[results.size()]);
        Arrays.sort(sortedResults, QUERY_RESULT_ORDERING);
        QuerySearchResultProvider firstResult = (QuerySearchResultProvider)sortedResults[0].value;
        int totalNumDocs = 0;
        int queueSize = firstResult.queryResult().from() + firstResult.queryResult().size();
        if (firstResult.includeFetch()) {
            queueSize *= sortedResults.length;
        }
        if (firstResult.queryResult().topDocs() instanceof TopFieldDocs) {
            TopFieldDocs fieldDocs = (TopFieldDocs)firstResult.queryResult().topDocs();
            for (int i = 0; i < fieldDocs.fields.length; ++i) {
                boolean allValuesAreNull = true;
                boolean resolvedField = false;
                for (AtomicArray.Entry entry : sortedResults) {
                    for (ScoreDoc doc : ((QuerySearchResultProvider)entry.value).queryResult().topDocs().scoreDocs) {
                        FieldDoc fDoc = (FieldDoc)doc;
                        if (fDoc.fields[i] == null) continue;
                        allValuesAreNull = false;
                        if (fDoc.fields[i] instanceof String) {
                            fieldDocs.fields[i] = new SortField(fieldDocs.fields[i].getField(), SortField.Type.STRING, fieldDocs.fields[i].getReverse());
                        }
                        resolvedField = true;
                        break;
                    }
                    if (resolvedField) break;
                }
                if (resolvedField || !allValuesAreNull || fieldDocs.fields[i].getField() == null) continue;
                fieldDocs.fields[i] = new SortField(fieldDocs.fields[i].getField(), SortField.Type.STRING, fieldDocs.fields[i].getReverse());
            }
            queue = new ShardFieldDocSortedHitQueue(fieldDocs.fields, queueSize);
            block6: for (AtomicArray.Entry entry : sortedResults) {
                QuerySearchResult result = ((QuerySearchResultProvider)entry.value).queryResult();
                ScoreDoc[] scoreDocs = result.topDocs().scoreDocs;
                totalNumDocs += scoreDocs.length;
                for (ScoreDoc doc : scoreDocs) {
                    doc.shardIndex = entry.index;
                    if (queue.insertWithOverflow((Object)doc) == doc) continue block6;
                }
            }
        } else {
            queue = new ScoreDocQueue(queueSize);
            block8: for (AtomicArray.Entry entry : sortedResults) {
                QuerySearchResult result = ((QuerySearchResultProvider)entry.value).queryResult();
                ScoreDoc[] scoreDocs = result.topDocs().scoreDocs;
                totalNumDocs += scoreDocs.length;
                for (ScoreDoc doc : scoreDocs) {
                    doc.shardIndex = entry.index;
                    if (queue.insertWithOverflow((Object)doc) == doc) continue block8;
                }
            }
        }
        int resultDocsSize = firstResult.queryResult().size();
        if (firstResult.includeFetch()) {
            resultDocsSize *= sortedResults.length;
        }
        if (totalNumDocs < queueSize) {
            resultDocsSize = totalNumDocs - firstResult.queryResult().from();
        }
        if (resultDocsSize <= 0) {
            return EMPTY_DOCS;
        }
        ScoreDoc[] shardDocs = new ScoreDoc[resultDocsSize];
        for (int i = resultDocsSize - 1; i >= 0; --i) {
            shardDocs[i] = (ScoreDoc)queue.pop();
        }
        return shardDocs;
    }

    public void fillDocIdsToLoad(AtomicArray<IntArrayList> docsIdsToLoad, ScoreDoc[] shardDocs) {
        for (ScoreDoc shardDoc : shardDocs) {
            IntArrayList list = docsIdsToLoad.get(shardDoc.shardIndex);
            if (list == null) {
                list = new IntArrayList();
                docsIdsToLoad.set(shardDoc.shardIndex, list);
            }
            list.add(shardDoc.doc);
        }
    }

    /*
     * WARNING - void declaration
     */
    public InternalSearchResponse merge(ScoreDoc[] sortedDocs, AtomicArray<? extends QuerySearchResultProvider> queryResultsArr, AtomicArray<? extends FetchSearchResultProvider> fetchResultsArr) {
        void var15_27;
        List<AtomicArray.Entry<? extends QuerySearchResultProvider>> queryResults = queryResultsArr.asList();
        List<AtomicArray.Entry<? extends FetchSearchResultProvider>> fetchResults = fetchResultsArr.asList();
        if (queryResults.isEmpty()) {
            return InternalSearchResponse.EMPTY;
        }
        QuerySearchResult firstResult = ((QuerySearchResultProvider)queryResults.get((int)0).value).queryResult();
        boolean sorted = false;
        int sortScoreIndex = -1;
        if (firstResult.topDocs() instanceof TopFieldDocs) {
            sorted = true;
            TopFieldDocs fieldDocs = (TopFieldDocs)firstResult.queryResult().topDocs();
            for (int i = 0; i < fieldDocs.fields.length; ++i) {
                if (fieldDocs.fields[i].getType() != SortField.Type.SCORE) continue;
                sortScoreIndex = i;
            }
        }
        InternalFacets facets = null;
        if (!queryResults.isEmpty() && firstResult.facets() != null && firstResult.facets().facets() != null && !firstResult.facets().facets().isEmpty()) {
            ArrayList<Facet> aggregatedFacets = Lists.newArrayList();
            ArrayList<Facet> namedFacets = Lists.newArrayList();
            for (Facet facet : firstResult.facets()) {
                namedFacets.clear();
                for (AtomicArray.Entry<SearchPhaseResult> entry : queryResults) {
                    for (Facet facet1 : ((QuerySearchResultProvider)entry.value).queryResult().facets()) {
                        if (!facet.getName().equals(facet1.getName())) continue;
                        namedFacets.add(facet1);
                    }
                }
                if (namedFacets.isEmpty()) continue;
                Facet aggregatedFacet = ((InternalFacet)namedFacets.get(0)).reduce(new InternalFacet.ReduceContext(this.cacheRecycler, namedFacets));
                aggregatedFacets.add(aggregatedFacet);
            }
            facets = new InternalFacets(aggregatedFacets);
        }
        long totalHits = 0L;
        float maxScore = Float.NEGATIVE_INFINITY;
        boolean timedOut = false;
        for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
            QuerySearchResult result = ((QuerySearchResultProvider)entry.value).queryResult();
            if (result.searchTimedOut()) {
                timedOut = true;
            }
            totalHits += (long)result.topDocs().totalHits;
            if (Float.isNaN(result.topDocs().getMaxScore())) continue;
            maxScore = Math.max(maxScore, result.topDocs().getMaxScore());
        }
        if (Float.isInfinite(maxScore)) {
            maxScore = Float.NaN;
        }
        for (AtomicArray.Entry<SearchPhaseResult> entry : fetchResults) {
            ((FetchSearchResultProvider)entry.value).fetchResult().initCounter();
        }
        ArrayList<InternalSearchHit> hits = new ArrayList<InternalSearchHit>();
        if (!fetchResults.isEmpty()) {
            for (ScoreDoc shardDoc : sortedDocs) {
                FetchSearchResult fetchResult;
                int index;
                FetchSearchResultProvider fetchResultProvider = fetchResultsArr.get(shardDoc.shardIndex);
                if (fetchResultProvider == null || (index = (fetchResult = fetchResultProvider.fetchResult()).counterGetAndIncrement()) >= fetchResult.hits().internalHits().length) continue;
                InternalSearchHit searchHit = fetchResult.hits().internalHits()[index];
                searchHit.score(shardDoc.score);
                searchHit.shard(fetchResult.shardTarget());
                if (sorted) {
                    FieldDoc fieldDoc = (FieldDoc)shardDoc;
                    searchHit.sortValues(fieldDoc.fields);
                    if (sortScoreIndex != -1) {
                        searchHit.score(((Number)fieldDoc.fields[sortScoreIndex]).floatValue());
                    }
                }
                hits.add(searchHit);
            }
        }
        Object var15_25 = null;
        if (!queryResults.isEmpty()) {
            HashMap<String, List<Suggest.Suggestion>> groupedSuggestions = new HashMap<String, List<Suggest.Suggestion>>();
            boolean hasSuggestions = false;
            for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
                Suggest shardResult = ((QuerySearchResultProvider)entry.value).queryResult().queryResult().suggest();
                if (shardResult == null) continue;
                hasSuggestions = true;
                Suggest.group(groupedSuggestions, shardResult);
            }
            Suggest suggest = hasSuggestions ? new Suggest(Suggest.Fields.SUGGEST, Suggest.reduce(groupedSuggestions)) : null;
        }
        InternalAggregations aggregations = null;
        if (!queryResults.isEmpty() && firstResult.aggregations() != null && firstResult.aggregations().asList() != null) {
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(queryResults.size());
            for (AtomicArray.Entry<? extends QuerySearchResultProvider> entry : queryResults) {
                aggregationsList.add((InternalAggregations)((QuerySearchResultProvider)entry.value).queryResult().aggregations());
            }
            aggregations = InternalAggregations.reduce(aggregationsList, this.cacheRecycler);
        }
        InternalSearchHits searchHits = new InternalSearchHits(hits.toArray(new InternalSearchHit[hits.size()]), totalHits, maxScore);
        return new InternalSearchResponse(searchHits, facets, aggregations, (Suggest)var15_27, timedOut);
    }
}

