/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.filter;

import java.io.IOException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.filter.FilterFacetExecutor;
import org.elasticsearch.search.facet.filter.InternalFilterFacet;
import org.elasticsearch.search.internal.SearchContext;

public class FilterFacetParser
extends AbstractComponent
implements FacetParser {
    @Inject
    public FilterFacetParser(Settings settings) {
        super(settings);
        InternalFilterFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"filter"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.POST;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        ParsedFilter parsedFilter = context.queryParserService().parseInnerFilter(parser);
        return new FilterFacetExecutor(parsedFilter == null ? Queries.MATCH_ALL_FILTER : parsedFilter.filter());
    }
}

