/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.theora;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gagravarr.ogg.HighLevelOggStreamPacket;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPacketWriter;
import org.gagravarr.ogg.OggStreamAudioData;
import org.gagravarr.ogg.OggStreamAudioVisualData;
import org.gagravarr.ogg.OggStreamVideoData;
import org.gagravarr.ogg.audio.OggAudioHeaders;
import org.gagravarr.ogg.audio.OggAudioStreamHeaders;
import org.gagravarr.skeleton.SkeletonFisbone;
import org.gagravarr.skeleton.SkeletonKeyFramePacket;
import org.gagravarr.skeleton.SkeletonPacketFactory;
import org.gagravarr.skeleton.SkeletonStream;
import org.gagravarr.theora.TheoraComments;
import org.gagravarr.theora.TheoraInfo;
import org.gagravarr.theora.TheoraPacket;
import org.gagravarr.theora.TheoraPacketFactory;
import org.gagravarr.theora.TheoraSetup;
import org.gagravarr.theora.TheoraVideoData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TheoraFile
extends HighLevelOggStreamPacket
implements Closeable {
    private OggFile ogg;
    private OggPacketReader r;
    private OggPacketWriter w;
    private int sid = -1;
    private TheoraInfo info;
    private TheoraComments comments;
    private TheoraSetup setup;
    private SkeletonStream skeleton;
    private Map<Integer, OggAudioStreamHeaders> soundtracks;
    private Map<OggAudioStreamHeaders, OggPacketWriter> soundtrackWriters;
    private LinkedList<AudioVisualDataAndSid> pendingPackets;
    private List<AudioVisualDataAndSid> writtenPackets;

    public TheoraFile(File f) throws IOException, FileNotFoundException {
        this(new OggFile(new FileInputStream(f)));
    }

    public TheoraFile(OggFile ogg) throws IOException {
        this(ogg.getPacketReader());
        this.ogg = ogg;
    }

    public TheoraFile(OggPacketReader r) throws IOException {
        this.r = r;
        this.pendingPackets = new LinkedList();
        this.soundtracks = new HashMap<Integer, OggAudioStreamHeaders>();
        HashSet<Integer> headerCompleteSoundtracks = new HashSet<Integer>();
        int packetsSinceSetup = -1;
        OggPacket p = null;
        while ((p = r.getNextPacket()) != null) {
            int psid = p.getSid();
            if (p.isBeginningOfStream() && p.getData().length > 10) {
                if (TheoraPacketFactory.isTheoraStream(p)) {
                    this.sid = psid;
                    this.info = (TheoraInfo)TheoraPacketFactory.create(p);
                    continue;
                }
                if (SkeletonPacketFactory.isSkeletonStream(p)) {
                    this.skeleton = new SkeletonStream(p);
                    continue;
                }
                try {
                    this.soundtracks.put(psid, OggAudioStreamHeaders.create(p));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            if (psid == this.sid) {
                TheoraPacket tp = TheoraPacketFactory.create(p);
                if (this.comments == null) {
                    this.comments = (TheoraComments)tp;
                    continue;
                }
                if (this.setup == null) {
                    this.setup = (TheoraSetup)tp;
                    packetsSinceSetup = 0;
                    continue;
                }
                this.pendingPackets.add(new AudioVisualDataAndSid((TheoraVideoData)tp, this.sid));
                if (++packetsSinceSetup <= 10) continue;
                break;
            }
            if (this.skeleton != null && this.skeleton.getSid() == psid) {
                this.skeleton.processPacket(p);
                continue;
            }
            if (!this.soundtracks.containsKey(psid)) continue;
            OggAudioStreamHeaders audio = this.soundtracks.get(psid);
            if (headerCompleteSoundtracks.contains(psid)) {
                this.pendingPackets.add(new AudioVisualDataAndSid(audio.createAudio(p), psid));
                continue;
            }
            boolean ongoing = audio.populate(p);
            if (ongoing) continue;
            headerCompleteSoundtracks.add(psid);
        }
        if (this.sid == -1) {
            throw new IllegalArgumentException("Supplied File is not Theora");
        }
    }

    public TheoraFile(OutputStream out) {
        this(out, new TheoraInfo(), new TheoraComments(), new TheoraSetup());
    }

    public TheoraFile(OutputStream out, TheoraInfo info, TheoraComments comments, TheoraSetup setup) {
        this(out, -1, info, comments, setup);
    }

    public TheoraFile(OutputStream out, int sid, TheoraInfo info, TheoraComments comments, TheoraSetup setup) {
        this.ogg = new OggFile(out);
        if (sid > 0) {
            this.w = this.ogg.getPacketWriter(sid);
            this.sid = sid;
        } else {
            this.w = this.ogg.getPacketWriter();
            this.sid = this.w.getSid();
        }
        this.writtenPackets = new ArrayList<AudioVisualDataAndSid>();
        this.soundtracks = new HashMap<Integer, OggAudioStreamHeaders>();
        this.soundtrackWriters = new HashMap<OggAudioStreamHeaders, OggPacketWriter>();
        this.info = info;
        this.comments = comments;
        this.setup = setup;
    }

    public int getSid() {
        return this.sid;
    }

    public TheoraInfo getInfo() {
        return this.info;
    }

    public TheoraComments getComments() {
        return this.comments;
    }

    public TheoraSetup getSetup() {
        return this.setup;
    }

    public SkeletonStream getSkeleton() {
        return this.skeleton;
    }

    public void ensureSkeleton() {
        if (this.skeleton != null) {
            return;
        }
        ArrayList<Integer> sids = new ArrayList<Integer>();
        if (this.sid != -1) {
            sids.add(this.sid);
        }
        for (Integer stsid : this.soundtracks.keySet()) {
            if (stsid == -1) continue;
            sids.add(stsid);
        }
        int[] sidsA = new int[sids.size()];
        for (int i = 0; i < sidsA.length; ++i) {
            sidsA[i] = (Integer)sids.get(i);
        }
        this.skeleton = new SkeletonStream(sidsA);
    }

    public Map<Integer, ? extends OggAudioHeaders> getSoundtrackStreams() {
        return this.soundtracks;
    }

    public Collection<? extends OggAudioHeaders> getSoundtracks() {
        return this.soundtracks.values();
    }

    public int addSoundtrack(OggAudioHeaders audio) {
        if (this.w == null) {
            throw new IllegalStateException("Not in write mode");
        }
        OggPacketWriter aw = null;
        aw = audio.getSid() == -1 ? this.ogg.getPacketWriter() : this.ogg.getPacketWriter(audio.getSid());
        int audioSid = aw.getSid();
        if (this.skeleton != null) {
            SkeletonFisbone bone = this.skeleton.addBoneForStream(audioSid);
            bone.setContentType(audio.getType().mimetype);
        }
        this.soundtracks.put(audioSid, (OggAudioStreamHeaders)audio);
        this.soundtrackWriters.put((OggAudioStreamHeaders)audio, aw);
        return audioSid;
    }

    public OggStreamAudioVisualData getNextAudioVisualPacket() throws IOException {
        return this.getNextAudioVisualPacket(null);
    }

    public OggStreamAudioVisualData getNextAudioVisualPacket(Set<Integer> sids) throws IOException {
        OggStreamAudioVisualData data = null;
        while (data == null && !this.pendingPackets.isEmpty()) {
            AudioVisualDataAndSid avd = this.pendingPackets.removeFirst();
            if (sids != null && !sids.contains(avd.sid)) continue;
            data = avd.data;
        }
        if (data == null) {
            OggPacket p = null;
            while ((p = this.r.getNextPacket()) != null) {
                if (sids != null && !sids.contains(p.getSid())) continue;
                if (p.getSid() == this.sid) {
                    data = (OggStreamVideoData)((Object)TheoraPacketFactory.create(p));
                    break;
                }
                if (this.soundtracks.containsKey(p.getSid())) {
                    OggAudioStreamHeaders audio = this.soundtracks.get(p.getSid());
                    data = audio.createAudio(p);
                    break;
                }
                throw new IllegalArgumentException("Unsupported stream type with sid " + p.getSid());
            }
        }
        return data;
    }

    public void writeVideoData(TheoraVideoData data) {
        this.writtenPackets.add(new AudioVisualDataAndSid(data, this.sid));
    }

    public void writeAudioData(OggStreamAudioData data, int audioSid) {
        if (!this.soundtracks.containsKey(audioSid)) {
            throw new IllegalArgumentException("Unknown audio stream with id " + audioSid);
        }
        this.writtenPackets.add(new AudioVisualDataAndSid(data, audioSid));
    }

    @Override
    public void close() throws IOException {
        if (this.r != null) {
            this.r = null;
            this.ogg.close();
            this.ogg = null;
        }
        if (this.w != null) {
            OggPacketWriter aw;
            OggPacketWriter sw = null;
            if (this.skeleton != null) {
                sw = this.ogg.getPacketWriter();
                sw.bufferPacket(this.skeleton.getFishead().write(), true);
            }
            this.w.bufferPacket(this.info.write(), true);
            for (OggAudioStreamHeaders audio : this.soundtrackWriters.keySet()) {
                aw = this.soundtrackWriters.get(audio);
                aw.bufferPacket(audio.getInfo().write(), true);
            }
            if (this.skeleton != null) {
                for (SkeletonFisbone bone : this.skeleton.getFisbones()) {
                    sw.bufferPacket(bone.write(), true);
                }
                for (SkeletonKeyFramePacket frame : this.skeleton.getKeyFrames()) {
                    sw.bufferPacket(frame.write(), true);
                }
            }
            this.w.bufferPacket(this.comments.write(), true);
            this.w.bufferPacket(this.setup.write(), true);
            for (OggAudioStreamHeaders audio : this.soundtrackWriters.keySet()) {
                aw = this.soundtrackWriters.get(audio);
                aw.bufferPacket(audio.getTags().write(), true);
                if (audio.getSetup() == null) continue;
                aw.bufferPacket(audio.getSetup().write(), true);
            }
            long lastGranule = 0L;
            for (AudioVisualDataAndSid avData : this.writtenPackets) {
                OggPacketWriter avw = this.w;
                if (avData.sid != this.sid) {
                    avw = this.soundtrackWriters.get(avData.sid);
                }
                if (avData.data.getGranulePosition() >= 0L && lastGranule != avData.data.getGranulePosition()) {
                    avw.flush();
                    lastGranule = avData.data.getGranulePosition();
                    avw.setGranulePosition(lastGranule);
                }
                avw.bufferPacket(avData.data.write());
                if (avw.getSizePendingFlush() <= 16384) continue;
                avw.flush();
            }
            this.w.close();
            this.w = null;
            if (sw != null) {
                sw.close();
                sw = null;
            }
            for (OggPacketWriter aw2 : this.soundtrackWriters.values()) {
                aw2.close();
            }
            this.ogg.close();
            this.ogg = null;
        }
    }

    public OggFile getOggFile() {
        return this.ogg;
    }

    protected static class AudioVisualDataAndSid {
        protected OggStreamAudioVisualData data;
        protected int sid;

        private AudioVisualDataAndSid(OggStreamAudioVisualData data, int sid) {
            this.data = data;
            this.sid = sid;
        }
    }
}

