/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import java.util.Random;
import org.apache.myfaces.application.viewstate.KeyFactory;
import org.apache.myfaces.shared.util.Hex;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

class RandomKeyFactory
extends KeyFactory<byte[]> {
    private final Random random;
    private final int length;

    public RandomKeyFactory(FacesContext facesContext) {
        this.length = WebConfigParamUtils.getIntegerInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN_LENGTH", 8);
        this.random = new Random((int)System.nanoTime() + this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateCounterKey(FacesContext facesContext) {
        Integer sequence;
        Object sessionObj;
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = sessionObj = externalContext.getSession(true);
        synchronized (object) {
            Map map = externalContext.getSessionMap();
            sequence = (Integer)map.get("jsf_sequence");
            sequence = sequence == null || sequence == Integer.MAX_VALUE ? Integer.valueOf(1) : Integer.valueOf(sequence + 1);
            map.put("jsf_sequence", sequence);
        }
        return sequence;
    }

    @Override
    public byte[] generateKey(FacesContext facesContext) {
        byte[] array = new byte[this.length];
        byte[] key = new byte[this.length + 4];
        this.random.nextBytes(array);
        for (int i = 0; i < array.length; ++i) {
            key[i] = array[i];
        }
        int value = this.generateCounterKey(facesContext);
        key[array.length] = (byte)(value >>> 24);
        key[array.length + 1] = (byte)(value >>> 16);
        key[array.length + 2] = (byte)(value >>> 8);
        key[array.length + 3] = (byte)value;
        return key;
    }

    @Override
    public String encode(byte[] key) {
        return new String(Hex.encodeHex(key));
    }

    @Override
    public byte[] decode(String value) {
        try {
            return Hex.decodeHex(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }
}

