/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;

public class ScopedAttributeResolver
extends ELResolver {
    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (base != null) {
            return;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        Map<String, Object> scopedMap = ScopedAttributeResolver.findScopedMap(ScopedAttributeResolver.facesContext(context), property);
        if (scopedMap != null) {
            scopedMap.put((String)property, value);
        } else {
            ScopedAttributeResolver.externalContext(context).getRequestMap().put((String)property, value);
        }
        context.setPropertyResolved(true);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base == null) {
            context.setPropertyResolved(true);
        }
        return false;
    }

    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        context.setPropertyResolved(true);
        Map<String, Object> scopedMap = ScopedAttributeResolver.findScopedMap(ScopedAttributeResolver.facesContext(context), property);
        if (scopedMap != null) {
            return scopedMap.get(property);
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        context.setPropertyResolved(true);
        return Object.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        ArrayList<FeatureDescriptor> descriptorList = new ArrayList<FeatureDescriptor>();
        ExternalContext extContext = ScopedAttributeResolver.externalContext(context);
        ScopedAttributeResolver.addDescriptorsToList(descriptorList, extContext.getRequestMap());
        ScopedAttributeResolver.addDescriptorsToList(descriptorList, extContext.getSessionMap());
        ScopedAttributeResolver.addDescriptorsToList(descriptorList, extContext.getApplicationMap());
        return descriptorList.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    private static void addDescriptorsToList(List<FeatureDescriptor> descriptorList, Map<String, Object> scopeMap) {
        Iterator<String> iterator = scopeMap.keySet().iterator();
        while (iterator.hasNext()) {
            String name;
            String strName = name = iterator.next();
            Class<?> runtimeType = scopeMap.get(strName).getClass();
            descriptorList.add(ScopedAttributeResolver.makeDescriptor(strName, runtimeType));
        }
    }

    private static FeatureDescriptor makeDescriptor(String name, Class<?> runtimeType) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setValue("resolvableAtDesignTime", Boolean.TRUE);
        fd.setValue("type", runtimeType);
        fd.setName(name);
        fd.setDisplayName(name);
        fd.setShortDescription(name);
        fd.setExpert(false);
        fd.setHidden(false);
        fd.setPreferred(true);
        return fd;
    }

    private static Map<String, Object> findScopedMap(FacesContext facesContext, Object property) {
        Map<String, Object> scopedMap;
        if (facesContext == null) {
            return null;
        }
        ExternalContext extContext = facesContext.getExternalContext();
        if (extContext == null) {
            return null;
        }
        boolean startup = extContext instanceof StartupServletExternalContextImpl;
        if (!startup && (scopedMap = extContext.getRequestMap()).containsKey(property)) {
            return scopedMap;
        }
        UIViewRoot root = facesContext.getViewRoot();
        if (root != null && (scopedMap = root.getViewMap(false)) != null && scopedMap.containsKey(property)) {
            return scopedMap;
        }
        if (!startup && (scopedMap = extContext.getSessionMap()).containsKey(property)) {
            return scopedMap;
        }
        scopedMap = extContext.getApplicationMap();
        if (scopedMap.containsKey(property)) {
            return scopedMap;
        }
        return null;
    }

    private static FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    private static ExternalContext externalContext(ELContext context) {
        FacesContext facesContext = ScopedAttributeResolver.facesContext(context);
        if (facesContext != null) {
            return ScopedAttributeResolver.facesContext(context).getExternalContext();
        }
        return null;
    }
}

