/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.ui;

import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.TagAttribute;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Map;

public class RepeatHandler
extends ComponentHandler {
    public RepeatHandler(ComponentConfig config) {
        super(config);
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type) {
        MetaRuleset meta = super.createMetaRuleset(type);
        if (!"http://xmlns.jcp.org/jsf/facelets".equals(this.tag.getNamespace()) && !"http://java.sun.com/jsf/facelets".equals(this.tag.getNamespace())) {
            meta.add(new TagMetaData(type));
        }
        meta.alias("class", "styleClass");
        return meta;
    }

    private class TagMetaData
    extends Metadata {
        private final String[] _attrs;

        public TagMetaData(Class<?> type) {
            HashSet<String> names = new HashSet<String>();
            for (TagAttribute attribute : RepeatHandler.this.tag.getAttributes().getAll()) {
                if ("class".equals(attribute.getLocalName())) {
                    names.add("styleClass");
                    continue;
                }
                names.add(attribute.getLocalName());
            }
            try {
                for (PropertyDescriptor descriptor : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
                    if (descriptor.getWriteMethod() == null) continue;
                    names.remove(descriptor.getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._attrs = names.toArray(new String[names.size()]);
        }

        @Override
        public void applyMetadata(FaceletContext ctx, Object instance) {
            UIComponent component = (UIComponent)instance;
            Map<String, Object> attrs = component.getAttributes();
            attrs.put("alias.element", RepeatHandler.this.tag.getQName());
            if (this._attrs.length > 0) {
                attrs.put("alias.attributes", this._attrs);
            }
        }
    }
}

