/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.core.serialization.JsonSerializer;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Linked;
import org.apache.olingo.commons.api.data.Operation;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;

public class JsonEntitySerializer
extends JsonSerializer {
    public JsonEntitySerializer(boolean serverMode, ContentType contentType) {
        super(serverMode, contentType);
    }

    protected void doSerialize(Entity entity, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        this.doContainerSerialize((ResWrap<Entity>)new ResWrap(null, null, (Object)entity), jgen);
    }

    protected void doContainerSerialize(ResWrap<Entity> container, JsonGenerator jgen) throws IOException, EdmPrimitiveTypeException {
        Entity entity = (Entity)container.getPayload();
        jgen.writeStartObject();
        if (this.serverMode && !this.isODataMetadataNone) {
            if (container.getContextURL() != null) {
                jgen.writeStringField("@odata.context", container.getContextURL().toASCIIString());
            }
            if (container.getMetadataETag() != null) {
                jgen.writeStringField("@odata.metadataEtag", container.getMetadataETag());
            }
            if (entity.getETag() != null) {
                jgen.writeStringField("@odata.etag", entity.getETag());
            }
        }
        if (entity.getType() != null && this.isODataMetadataFull) {
            jgen.writeStringField("@odata.type", new EdmTypeInfo.Builder().setTypeExpression(entity.getType()).build().external());
        }
        if (entity.getId() != null && this.isODataMetadataFull) {
            jgen.writeStringField("@odata.id", entity.getId().toASCIIString());
        }
        for (Annotation annotation : entity.getAnnotations()) {
            this.valuable(jgen, (Valuable)annotation, "@" + annotation.getTerm());
        }
        for (Property property : entity.getProperties()) {
            this.valuable(jgen, (Valuable)property, property.getName());
        }
        if (this.serverMode && entity.getEditLink() != null && entity.getEditLink().getHref() != null && this.isODataMetadataFull) {
            jgen.writeStringField("@odata.editLink", entity.getEditLink().getHref());
            if (entity.isMediaEntity() && this.isODataMetadataFull) {
                jgen.writeStringField("@odata.mediaReadLink", entity.getEditLink().getHref() + "/$value");
            }
        }
        if (!this.isODataMetadataNone) {
            this.links((Linked)entity, jgen);
        }
        if (this.isODataMetadataFull) {
            for (Link link : entity.getMediaEditLinks()) {
                if (link.getTitle() == null) {
                    jgen.writeStringField("@odata.mediaEditLink", link.getHref());
                }
                if (link.getInlineEntity() != null) {
                    jgen.writeObjectField(link.getTitle(), (Object)link.getInlineEntity());
                }
                if (link.getInlineEntitySet() == null) continue;
                jgen.writeArrayFieldStart(link.getTitle());
                for (Entity subEntry : link.getInlineEntitySet().getEntities()) {
                    jgen.writeObject((Object)subEntry);
                }
                jgen.writeEndArray();
            }
        }
        if (this.serverMode && this.isODataMetadataFull) {
            for (Operation operation : entity.getOperations()) {
                String anchor = operation.getMetadataAnchor();
                int index = anchor.lastIndexOf(35);
                jgen.writeObjectFieldStart('#' + anchor.substring(index < 0 ? 0 : index + 1));
                jgen.writeStringField("title", operation.getTitle());
                jgen.writeStringField("target", operation.getTarget().toASCIIString());
                jgen.writeEndObject();
            }
        }
        jgen.writeEndObject();
    }
}

