/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.primitivetype;

import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.core.edm.primitivetype.AbstractGeospatialType;

public final class EdmGeographyLineString
extends AbstractGeospatialType<LineString> {
    private static final EdmGeographyLineString INSTANCE = new EdmGeographyLineString();

    public static EdmGeographyLineString getInstance() {
        return INSTANCE;
    }

    public EdmGeographyLineString() {
        super(LineString.class, Geospatial.Dimension.GEOGRAPHY, Geospatial.Type.LINESTRING);
    }

    @Override
    protected <T> T internalValueOfString(String value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode, Class<T> returnType) throws EdmPrimitiveTypeException {
        LineString lineString = this.stringToLineString(value, isNullable, maxLength, precision, scale, isUnicode);
        if (returnType.isAssignableFrom(LineString.class)) {
            return returnType.cast(lineString);
        }
        throw new EdmPrimitiveTypeException("The value type " + returnType + " is not supported.");
    }

    @Override
    protected <T> String internalValueToString(T value, Boolean isNullable, Integer maxLength, Integer precision, Integer scale, Boolean isUnicode) throws EdmPrimitiveTypeException {
        if (value instanceof LineString) {
            return this.toString((LineString)value, isNullable, maxLength, precision, scale, isUnicode);
        }
        throw new EdmPrimitiveTypeException("The value type " + value.getClass() + " is not supported.");
    }
}

