/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.util.Locale;
import javax.persistence.LockModeType;
import org.apache.openjpa.persistence.HintValueConverter;

public class MixedLockLevelsHelper
implements HintValueConverter {
    public static int toLockLevel(LockModeType mode) {
        if (mode == null || mode == LockModeType.NONE) {
            return 0;
        }
        if (mode == LockModeType.READ) {
            return 10;
        }
        if (mode == LockModeType.OPTIMISTIC) {
            return 15;
        }
        if (mode == LockModeType.WRITE) {
            return 20;
        }
        if (mode == LockModeType.OPTIMISTIC_FORCE_INCREMENT) {
            return 25;
        }
        if (mode == LockModeType.PESSIMISTIC_READ) {
            return 30;
        }
        if (mode == LockModeType.PESSIMISTIC_WRITE) {
            return 40;
        }
        return 50;
    }

    public static int toLockLevel(int mode) {
        switch (mode) {
            case -99: 
            case 0: 
            case 10: 
            case 15: 
            case 20: 
            case 25: 
            case 30: 
            case 40: 
            case 50: {
                return mode;
            }
        }
        throw new IllegalArgumentException("Unknown lock level " + mode);
    }

    public static LockModeType fromLockLevel(int level) {
        if (level < 10) {
            return LockModeType.NONE;
        }
        if (level < 15) {
            return LockModeType.READ;
        }
        if (level < 20) {
            return LockModeType.OPTIMISTIC;
        }
        if (level < 25) {
            return LockModeType.WRITE;
        }
        if (level < 30) {
            return LockModeType.OPTIMISTIC_FORCE_INCREMENT;
        }
        if (level < 40) {
            return LockModeType.PESSIMISTIC_READ;
        }
        if (level < 50) {
            return LockModeType.PESSIMISTIC_WRITE;
        }
        return LockModeType.PESSIMISTIC_FORCE_INCREMENT;
    }

    @Override
    public boolean canConvert(Class<?> type) {
        return type == LockModeType.class || type == String.class || type == Integer.class || type == Integer.TYPE;
    }

    @Override
    public Object convert(Object original) {
        if (original instanceof LockModeType) {
            return MixedLockLevelsHelper.toLockLevel((LockModeType)((Object)original));
        }
        if (original instanceof String) {
            try {
                int value = Integer.parseInt(original.toString());
                return MixedLockLevelsHelper.toLockLevel(value);
            }
            catch (NumberFormatException nfe) {
                if ("none".equalsIgnoreCase(original.toString())) {
                    return 0;
                }
                return MixedLockLevelsHelper.toLockLevel(LockModeType.valueOf(original.toString().toUpperCase(Locale.ENGLISH).replace('-', '_')));
            }
        }
        if (original instanceof Integer) {
            return MixedLockLevelsHelper.toLockLevel((Integer)original);
        }
        throw new IllegalArgumentException("can not convert " + original + " of " + original.getClass());
    }
}

