/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Basic;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AbstractMetaDataDefaults;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.DetachedState;
import org.apache.openjpa.persistence.PersistenceStrategy;
import org.apache.openjpa.persistence.Persistent;
import org.apache.openjpa.persistence.PersistentCollection;
import org.apache.openjpa.persistence.PersistentMap;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UserException;

public class PersistenceMetaDataDefaults
extends AbstractMetaDataDefaults {
    private static final Localizer _loc = Localizer.forPackage(PersistenceMetaDataDefaults.class);
    private static final Map<Class<?>, PersistenceStrategy> _strats = new HashMap();
    private static final Set<String> _ignoredAnnos = new HashSet<String>();
    protected AccessFilter propertyAccessFilter = new AccessFilter(AccessType.PROPERTY);
    protected AccessFilter fieldAccessFilter = new AccessFilter(AccessType.FIELD);
    protected MemberFilter fieldFilter = new MemberFilter(Field.class);
    protected MemberFilter methodFilter = new MemberFilter(Method.class);
    protected TransientFilter nonTransientFilter = new TransientFilter(false);
    protected AnnotatedFilter annotatedFilter = new AnnotatedFilter();
    protected GetterFilter getterFilter = new GetterFilter();
    protected SetterFilter setterFilter = new SetterFilter();
    private Boolean _isAbstractMappingUniDirectional = null;
    private Boolean _isNonDefaultMappingAllowed = null;
    private String _defaultSchema;
    private Boolean _isCascadePersistPersistenceUnitDefaultEnabled = null;

    public PersistenceMetaDataDefaults() {
        this.setCallbackMode(50);
        this.setDataStoreObjectIdFieldUnwrapped(true);
    }

    public static PersistenceStrategy getPersistenceStrategy(FieldMetaData fmd, Member member) {
        return PersistenceMetaDataDefaults.getPersistenceStrategy(fmd, member, false);
    }

    public static PersistenceStrategy getPersistenceStrategy(FieldMetaData fmd, Member member, boolean ignoreTransient) {
        int code;
        Class<?> type;
        if (member == null) {
            return null;
        }
        AnnotatedElement el = (AnnotatedElement)((Object)member);
        if (!ignoreTransient && AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(el, Transient.class)).booleanValue()) {
            return PersistenceStrategy.TRANSIENT;
        }
        if (fmd != null && fmd.getManagement() != 3) {
            return null;
        }
        PersistenceStrategy pstrat = null;
        for (Annotation anno : el.getDeclaredAnnotations()) {
            if (pstrat != null && _strats.containsKey(anno.annotationType())) {
                throw new MetaDataException(_loc.get("already-pers", member));
            }
            if (pstrat != null) continue;
            pstrat = _strats.get(anno.annotationType());
        }
        if (pstrat != null) {
            return pstrat;
        }
        if (fmd != null) {
            type = fmd.getType();
            code = fmd.getTypeCode();
        } else if (member instanceof Field) {
            type = ((Field)member).getType();
            code = JavaTypes.getTypeCode(type);
        } else {
            type = ((Method)member).getReturnType();
            code = JavaTypes.getTypeCode(type);
        }
        switch (code) {
            case 11: {
                if (type != byte[].class && type != char[].class && type != Byte[].class && type != Character[].class) break;
                return PersistenceStrategy.BASIC;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return PersistenceStrategy.BASIC;
            }
            case 8: {
                if (!Enum.class.isAssignableFrom(type)) break;
                return PersistenceStrategy.BASIC;
            }
        }
        if (AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(type, Embeddable.class)).booleanValue()) {
            return PersistenceStrategy.EMBEDDED;
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return PersistenceStrategy.BASIC;
        }
        return null;
    }

    public void setDefaultAccessType(String type) {
        if ("PROPERTY".equals(type.toUpperCase(Locale.ENGLISH))) {
            this.setDefaultAccessType(AccessCode.PROPERTY);
        } else if ("FIELD".equals(type.toUpperCase(Locale.ENGLISH))) {
            this.setDefaultAccessType(AccessCode.FIELD);
        } else {
            throw new IllegalArgumentException(_loc.get("access-invalid", type).toString());
        }
    }

    @Override
    public void populate(ClassMetaData meta, int access) {
        this.populate(meta, access, false);
    }

    @Override
    public void populate(ClassMetaData meta, int access, boolean ignoreTransient) {
        if (AccessCode.isUnknown(access)) {
            access = this.determineAccessType(meta);
        }
        if (AccessCode.isUnknown(access)) {
            this.error(meta, _loc.get("access-unknown", meta));
        }
        super.populate(meta, access, ignoreTransient);
        meta.setDetachable(true);
    }

    @Override
    protected void populate(FieldMetaData fmd) {
        PersistenceMetaDataDefaults.setCascadeNone(fmd);
        PersistenceMetaDataDefaults.setCascadeNone(fmd.getKey());
        PersistenceMetaDataDefaults.setCascadeNone(fmd.getElement());
    }

    static void setCascadeNone(ValueMetaData vmd) {
        vmd.setCascadePersist(0);
        vmd.setCascadeRefresh(0);
        vmd.setCascadeAttach(0);
        vmd.setCascadeDetach(0);
    }

    ClassMetaData getCachedSuperclassMetaData(ClassMetaData meta) {
        if (meta == null) {
            return null;
        }
        Class<?> cls = meta.getDescribedType();
        Class<?> sup = cls.getSuperclass();
        if (sup == null || "java.lang.Object".equals(sup.getName())) {
            return null;
        }
        MetaDataRepository repos = meta.getRepository();
        ClassMetaData supMeta = repos.getCachedMetaData(sup);
        if (supMeta == null) {
            supMeta = repos.getMetaData(sup, null, false);
        }
        return supMeta;
    }

    private int determineAccessType(ClassMetaData meta) {
        ClassMetaData sup;
        if (meta == null) {
            return AccessCode.UNKNOWN;
        }
        if (meta.getDescribedType().isInterface()) {
            return AccessCode.PROPERTY;
        }
        if (!AccessCode.isUnknown(meta)) {
            return meta.getAccessType();
        }
        int access = this.determineExplicitAccessType(meta.getDescribedType());
        if (!AccessCode.isUnknown(access)) {
            return access;
        }
        access = this.determineImplicitAccessType(meta.getDescribedType(), meta.getRepository().getConfiguration());
        if (!AccessCode.isUnknown(access)) {
            return access;
        }
        ClassMetaData tmpSup = sup = this.getCachedSuperclassMetaData(meta);
        while (tmpSup != null && tmpSup.isExplicitAccess()) {
            if ((tmpSup = this.getCachedSuperclassMetaData(tmpSup)) == null) continue;
            sup = tmpSup;
        }
        if (sup != null && !AccessCode.isUnknown(sup)) {
            return sup.getAccessType();
        }
        this.trace(meta, _loc.get("access-default", meta, AccessCode.toClassString(this.getDefaultAccessType())));
        return this.getDefaultAccessType();
    }

    private int determineImplicitAccessType(Class<?> cls, OpenJPAConfiguration conf) {
        boolean mixed;
        if (cls.isInterface()) {
            return AccessCode.PROPERTY;
        }
        AnnotatedElement[] allFields = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction(cls));
        AnnotatedElement[] methods = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction(cls));
        List<Field> fields = this.filter(allFields, new InclusiveFilter[]{new TransientFilter(true)});
        this.getterFilter.setIncludePrivate(conf.getCompatibilityInstance().getPrivatePersistentProperties());
        List<Method> getters = this.filter(methods, new InclusiveFilter[]{this.getterFilter});
        if (fields.isEmpty() && getters.isEmpty()) {
            return AccessCode.EMPTY;
        }
        fields = this.filter(fields, this.annotatedFilter);
        getters = this.filter(getters, this.annotatedFilter);
        List setters = this.filter(methods, new InclusiveFilter[]{this.setterFilter});
        getters = this.matchGetterAndSetter(getters, setters);
        boolean bl = mixed = !fields.isEmpty() && !getters.isEmpty();
        if (mixed) {
            throw new UserException(_loc.get("access-mixed", cls, this.toFieldNames(fields), this.toMethodNames(getters)));
        }
        if (!fields.isEmpty()) {
            return AccessCode.FIELD;
        }
        if (!getters.isEmpty()) {
            return AccessCode.PROPERTY;
        }
        return AccessCode.UNKNOWN;
    }

    private int determineExplicitAccessType(Class<?> cls) {
        Access access = cls.getAnnotation(Access.class);
        return access == null ? AccessCode.UNKNOWN : (access.value() == AccessType.FIELD ? AccessCode.FIELD : AccessCode.PROPERTY) | AccessCode.EXPLICIT;
    }

    private List<Method> matchGetterAndSetter(List<Method> getters, List<Method> setters) {
        ArrayList<Method> unmatched = new ArrayList<Method>();
        for (Method getter : getters) {
            String getterName = getter.getName();
            Class<?> getterReturnType = getter.getReturnType();
            String expectedSetterName = "set" + getterName.substring((PersistenceMetaDataDefaults.isBooleanGetter(getter) ? "is" : "get").length());
            boolean matched = false;
            for (Method setter : setters) {
                Class<?> setterArgType = setter.getParameterTypes()[0];
                String actualSetterName = setter.getName();
                matched = actualSetterName.equals(expectedSetterName) && setterArgType == getterReturnType;
                if (!matched) continue;
                break;
            }
            if (matched) continue;
            unmatched.add(getter);
        }
        getters.removeAll(unmatched);
        return getters;
    }

    List<Field> getPersistentFields(ClassMetaData meta, boolean ignoreTransient) {
        boolean explicit = meta.isExplicitAccess();
        boolean unknown = AccessCode.isUnknown(meta);
        boolean isField = AccessCode.isField(meta);
        if (explicit || unknown || isField) {
            AnnotatedElement[] fields = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction(meta.getDescribedType()));
            InclusiveFilter[] inclusiveFilterArray = new InclusiveFilter[4];
            inclusiveFilterArray[0] = this.fieldFilter;
            inclusiveFilterArray[1] = ignoreTransient ? null : this.nonTransientFilter;
            InclusiveFilter<AnnotatedElement> inclusiveFilter = inclusiveFilterArray[2] = unknown || isField ? null : this.annotatedFilter;
            inclusiveFilterArray[3] = explicit ? (isField ? null : this.fieldAccessFilter) : null;
            return this.filter(fields, inclusiveFilterArray);
        }
        return Collections.EMPTY_LIST;
    }

    List<Method> getPersistentMethods(ClassMetaData meta, boolean ignoreTransient) {
        boolean explicit = meta.isExplicitAccess();
        boolean unknown = AccessCode.isUnknown(meta.getAccessType());
        boolean isProperty = AccessCode.isProperty(meta.getAccessType());
        if (explicit || unknown || isProperty) {
            AnnotatedElement[] publicMethods = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction(meta.getDescribedType()));
            this.getterFilter.setIncludePrivate(meta.getRepository().getConfiguration().getCompatibilityInstance().getPrivatePersistentProperties());
            InclusiveFilter[] inclusiveFilterArray = new InclusiveFilter[5];
            inclusiveFilterArray[0] = this.methodFilter;
            inclusiveFilterArray[1] = this.getterFilter;
            inclusiveFilterArray[2] = ignoreTransient ? null : this.nonTransientFilter;
            InclusiveFilter<AnnotatedElement> inclusiveFilter = inclusiveFilterArray[3] = unknown || isProperty ? null : this.annotatedFilter;
            inclusiveFilterArray[4] = explicit ? (isProperty ? null : this.propertyAccessFilter) : null;
            List<Method> getters = this.filter(publicMethods, inclusiveFilterArray);
            List setters = this.filter(publicMethods, new InclusiveFilter[]{this.setterFilter});
            getters = this.matchGetterAndSetter(getters, setters);
            return getters;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Member> getPersistentMembers(ClassMetaData meta, boolean ignoreTransient) {
        ArrayList<Member> members = new ArrayList<Member>();
        List<Field> fields = this.getPersistentFields(meta, ignoreTransient);
        List<Method> getters = this.getPersistentMethods(meta, ignoreTransient);
        boolean isMixed = !fields.isEmpty() && !getters.isEmpty();
        boolean isEmpty = fields.isEmpty() && getters.isEmpty();
        boolean explicit = meta.isExplicitAccess();
        boolean unknown = AccessCode.isUnknown(meta.getAccessType());
        if (isEmpty) {
            this.warn(meta, _loc.get("access-empty", meta));
            return Collections.EMPTY_LIST;
        }
        if (explicit) {
            if (isMixed) {
                this.assertNoDuplicate(fields, getters);
                meta.setAccessType(AccessCode.MIXED | meta.getAccessType());
                members.addAll(fields);
                members.addAll(getters);
            } else {
                members.addAll(fields.isEmpty() ? getters : fields);
            }
        } else {
            if (isMixed) {
                this.error(meta, _loc.get("access-mixed", meta, fields, getters));
            }
            if (fields.isEmpty()) {
                meta.setAccessType(AccessCode.PROPERTY);
                members.addAll(getters);
            } else {
                meta.setAccessType(AccessCode.FIELD);
                members.addAll(fields);
            }
        }
        return members;
    }

    void assertNoDuplicate(List<Field> fields, List<Method> getters) {
    }

    void error(ClassMetaData meta, Localizer.Message message) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.Runtime");
        log.error(message.toString());
        throw new UserException(message.toString());
    }

    void warn(ClassMetaData meta, Localizer.Message message) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.Runtime");
        log.warn(message.toString());
    }

    void trace(ClassMetaData meta, Localizer.Message message) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.Runtime");
        log.trace(message.toString());
    }

    @Override
    protected List<String> getFieldAccessNames(ClassMetaData meta) {
        return PersistenceMetaDataDefaults.toNames(this.getPersistentFields(meta, false));
    }

    @Override
    protected List<String> getPropertyAccessNames(ClassMetaData meta) {
        return PersistenceMetaDataDefaults.toNames(this.getPersistentMethods(meta, false));
    }

    protected boolean isDefaultPersistent(ClassMetaData meta, Member member, String name) {
        return this.isDefaultPersistent(meta, member, name, false);
    }

    @Override
    protected boolean isDefaultPersistent(ClassMetaData meta, Member member, String name, boolean ignoreTransient) {
        PersistenceStrategy strat;
        int mods = member.getModifiers();
        if (Modifier.isTransient(mods)) {
            return false;
        }
        int access = meta.getAccessType();
        if (member instanceof Field) {
            if (AccessCode.isProperty(access) && !this.isAnnotatedAccess(member, AccessType.FIELD)) {
                return false;
            }
        } else if (member instanceof Method) {
            if (AccessCode.isField(access) && !this.isAnnotatedAccess(member, AccessType.PROPERTY)) {
                return false;
            }
            try {
                String setterName = member.getName().startsWith("is") ? "set" + member.getName().substring(2) : "set" + member.getName().substring(3);
                Method setter = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction(meta.getDescribedType(), setterName, new Class[]{((Method)member).getReturnType()}));
                if (setter == null && !this.isAnnotatedTransient(member)) {
                    this.logNoSetter(meta, name, null);
                    return false;
                }
            }
            catch (Exception e) {
                if (!this.isAnnotatedTransient(member)) {
                    this.logNoSetter(meta, name, e);
                }
                return false;
            }
        }
        if ((strat = PersistenceMetaDataDefaults.getPersistenceStrategy(null, member, ignoreTransient)) == null) {
            this.warn(meta, _loc.get("no-pers-strat", meta.getDescribedTypeString() + "." + name));
            return false;
        }
        return strat != PersistenceStrategy.TRANSIENT;
    }

    private boolean isAnnotatedTransient(Member member) {
        return member instanceof AnnotatedElement && AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)((Object)member), Transient.class)) != false;
    }

    private boolean isAnnotatedAccess(Member member, AccessType type) {
        if (member == null) {
            return false;
        }
        Access anno = AccessController.doPrivileged(J2DoPrivHelper.getAnnotationAction((AnnotatedElement)((Object)member), Access.class));
        return anno != null && anno.value() == type;
    }

    private boolean isAnnotated(Member member) {
        return member != null && member instanceof AnnotatedElement && this.annotatedFilter.includes((AnnotatedElement)((Object)member));
    }

    private boolean isNotTransient(Member member) {
        return member != null && member instanceof AnnotatedElement && this.nonTransientFilter.includes((AnnotatedElement)((Object)member));
    }

    @Override
    public Member getMemberByProperty(ClassMetaData meta, String property, int access, boolean applyDefaultRule) {
        int accessCode;
        Class<?> cls = meta.getDescribedType();
        Field field = Reflection.findField(cls, property, false);
        Method getter = Reflection.findGetter(cls, property, false);
        Method setter = Reflection.findSetter(cls, property, false);
        int n = accessCode = AccessCode.isUnknown(access) ? meta.getAccessType() : access;
        if (field == null && getter == null) {
            this.error(meta, _loc.get("access-no-property", cls, property));
        }
        if (this.isNotTransient(getter) && this.isAnnotated(getter) && this.isNotTransient(field) && this.isAnnotated(field)) {
            throw new IllegalStateException(_loc.get("access-duplicate", field, getter).toString());
        }
        if (AccessCode.isField(accessCode)) {
            if (this.isAnnotatedAccess(getter, AccessType.PROPERTY)) {
                meta.setAccessType(AccessCode.MIXED | meta.getAccessType());
                return getter;
            }
            return field == null ? getter : field;
        }
        if (AccessCode.isProperty(accessCode)) {
            if (this.isAnnotatedAccess(field, AccessType.FIELD)) {
                meta.setAccessType(AccessCode.MIXED | meta.getAccessType());
                return field;
            }
            return getter == null ? field : getter;
        }
        if (AccessCode.isUnknown(accessCode)) {
            if (this.isAnnotated(field)) {
                meta.setAccessType(AccessCode.FIELD);
                return field;
            }
            if (this.isAnnotated(getter)) {
                meta.setAccessType(AccessCode.PROPERTY);
                return getter;
            }
            this.warn(meta, _loc.get("access-none", meta, property));
            throw new IllegalStateException(_loc.get("access-none", meta, property).toString());
        }
        throw new InternalException(meta + " " + AccessCode.toClassString(meta.getAccessType()));
    }

    <T extends AnnotatedElement> List<T> filter(T[] array, InclusiveFilter ... filters) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : array) {
            boolean include = true;
            for (InclusiveFilter f : filters) {
                if (f == null || f.includes(e)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            result.add(e);
        }
        return result;
    }

    <T extends AnnotatedElement> List<T> filter(List<T> list, InclusiveFilter ... filters) {
        ArrayList<AnnotatedElement> result = new ArrayList<AnnotatedElement>();
        for (AnnotatedElement e : list) {
            boolean include = true;
            for (InclusiveFilter f : filters) {
                if (f == null || f.includes(e)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            result.add(e);
        }
        return result;
    }

    private void logNoSetter(ClassMetaData meta, String name, Exception e) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.MetaData");
        if (log.isWarnEnabled()) {
            log.warn(_loc.get("no-setter-for-getter", name, meta.getDescribedType().getName()));
        } else if (log.isTraceEnabled()) {
            log.warn(_loc.get("no-setter-for-getter", name, meta.getDescribedType().getName()), e);
        }
    }

    private Log getLog(ClassMetaData meta) {
        return meta.getRepository().getConfiguration().getLog("openjpa.MetaData");
    }

    String toFieldNames(List<Field> fields) {
        return fields.toString();
    }

    String toMethodNames(List<Method> methods) {
        return methods.toString();
    }

    @Override
    public boolean isAbstractMappingUniDirectional(OpenJPAConfiguration conf) {
        if (this._isAbstractMappingUniDirectional == null) {
            this.setAbstractMappingUniDirectional(conf);
        }
        return this._isAbstractMappingUniDirectional;
    }

    public void setAbstractMappingUniDirectional(OpenJPAConfiguration conf) {
        this._isAbstractMappingUniDirectional = conf.getCompatibilityInstance().isAbstractMappingUniDirectional();
    }

    @Override
    public boolean isNonDefaultMappingAllowed(OpenJPAConfiguration conf) {
        if (this._isNonDefaultMappingAllowed == null) {
            this.setNonDefaultMappingAllowed(conf);
        }
        return this._isNonDefaultMappingAllowed;
    }

    public void setNonDefaultMappingAllowed(OpenJPAConfiguration conf) {
        this._isNonDefaultMappingAllowed = conf.getCompatibilityInstance().isNonDefaultMappingAllowed();
    }

    @Override
    public Boolean isDefaultCascadePersistEnabled() {
        return this._isCascadePersistPersistenceUnitDefaultEnabled;
    }

    @Override
    public void setDefaultCascadePersistEnabled(Boolean bool) {
        this._isCascadePersistPersistenceUnitDefaultEnabled = bool;
    }

    @Override
    public String getDefaultSchema() {
        return this._defaultSchema;
    }

    @Override
    public void setDefaultSchema(String schema) {
        this._defaultSchema = schema;
    }

    static {
        _strats.put(Basic.class, PersistenceStrategy.BASIC);
        _strats.put(ManyToOne.class, PersistenceStrategy.MANY_ONE);
        _strats.put(OneToOne.class, PersistenceStrategy.ONE_ONE);
        _strats.put(Embedded.class, PersistenceStrategy.EMBEDDED);
        _strats.put(EmbeddedId.class, PersistenceStrategy.EMBEDDED);
        _strats.put(OneToMany.class, PersistenceStrategy.ONE_MANY);
        _strats.put(ManyToMany.class, PersistenceStrategy.MANY_MANY);
        _strats.put(Persistent.class, PersistenceStrategy.PERS);
        _strats.put(PersistentCollection.class, PersistenceStrategy.PERS_COLL);
        _strats.put(ElementCollection.class, PersistenceStrategy.ELEM_COLL);
        _strats.put(PersistentMap.class, PersistenceStrategy.PERS_MAP);
        _ignoredAnnos.add(DetachedState.class.getName());
        _ignoredAnnos.add(PostLoad.class.getName());
        _ignoredAnnos.add(PostPersist.class.getName());
        _ignoredAnnos.add(PostRemove.class.getName());
        _ignoredAnnos.add(PostUpdate.class.getName());
        _ignoredAnnos.add(PrePersist.class.getName());
        _ignoredAnnos.add(PreRemove.class.getName());
        _ignoredAnnos.add(PreUpdate.class.getName());
    }

    static class AnnotatedFilter
    implements InclusiveFilter<AnnotatedElement> {
        AnnotatedFilter() {
        }

        @Override
        public boolean includes(AnnotatedElement obj) {
            Annotation[] annos;
            for (Annotation anno : annos = AccessController.doPrivileged(J2DoPrivHelper.getAnnotationsAction(obj))) {
                String name = anno.annotationType().getName();
                if (!name.startsWith("jakarta.persistence.") && !name.startsWith("org.apache.openjpa.persistence.") || _ignoredAnnos.contains(name)) continue;
                return true;
            }
            return false;
        }
    }

    static class TransientFilter
    implements InclusiveFilter<AnnotatedElement> {
        final boolean modifierOnly;

        public TransientFilter(boolean modOnly) {
            this.modifierOnly = modOnly;
        }

        @Override
        public boolean includes(AnnotatedElement obj) {
            if (this.modifierOnly) {
                return !Modifier.isTransient(((Member)((Object)obj)).getModifiers());
            }
            return !obj.isAnnotationPresent(Transient.class) && !Modifier.isTransient(((Member)((Object)obj)).getModifiers());
        }
    }

    static class MemberFilter
    implements InclusiveFilter<AnnotatedElement> {
        final Class<?> target;

        public MemberFilter(Class<?> target) {
            this.target = target;
        }

        @Override
        public boolean includes(AnnotatedElement obj) {
            int mods = ((Member)((Object)obj)).getModifiers();
            return obj.getClass() == this.target && !Modifier.isStatic(mods) && !Modifier.isFinal(mods) && !Modifier.isTransient(mods) && !Modifier.isNative(mods);
        }
    }

    static class AccessFilter
    implements InclusiveFilter<AnnotatedElement> {
        final AccessType target;

        public AccessFilter(AccessType target) {
            this.target = target;
        }

        @Override
        public boolean includes(AnnotatedElement obj) {
            Access access = obj.getAnnotation(Access.class);
            return access != null && access.value().equals((Object)this.target);
        }
    }

    static class SetterFilter
    implements InclusiveFilter<Method> {
        SetterFilter() {
        }

        @Override
        public boolean includes(Method method) {
            return SetterFilter.isSetter(method);
        }

        public static boolean isSetter(Method method) {
            String methodName = method.getName();
            return AbstractMetaDataDefaults.startsWith(methodName, "set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        }
    }

    static class GetterFilter
    implements InclusiveFilter<Method> {
        private boolean includePrivate;

        GetterFilter() {
        }

        @Override
        public boolean includes(Method method) {
            return AbstractMetaDataDefaults.isGetter(method, this.isIncludePrivate());
        }

        public void setIncludePrivate(boolean includePrivate) {
            this.includePrivate = includePrivate;
        }

        public boolean isIncludePrivate() {
            return this.includePrivate;
        }
    }

    private static interface InclusiveFilter<T extends AnnotatedElement> {
        public boolean includes(T var1);
    }
}

