/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util.proxy;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.function.IntFunction;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DetachedStateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.CollectionChangeTracker;
import org.apache.openjpa.util.DelayedCollectionChangeTrackerImpl;
import org.apache.openjpa.util.Proxies;
import org.apache.openjpa.util.Proxy;
import org.apache.openjpa.util.proxy.DelayedProxy;
import org.apache.openjpa.util.proxy.ProxyCollection;
import org.apache.openjpa.util.proxy.ProxyCollections;

public class DelayedVectorProxy
extends Vector
implements ProxyCollection,
DelayedProxy {
    private transient OpenJPAStateManager sm;
    private transient int field;
    private transient CollectionChangeTracker changeTracker;
    private transient Class elementType;
    private transient OpenJPAStateManager _ownerSm;
    private transient boolean _directAccess = false;
    private transient BrokerFactory _brokerFactory = null;
    private transient Broker _broker = null;
    private transient OpenJPAStateManager _delayedSm;
    private transient int _delayedField;
    private transient boolean _detached = false;

    public DelayedVectorProxy(int paramInt) {
        super(paramInt);
    }

    public DelayedVectorProxy() {
    }

    public DelayedVectorProxy(Collection paramCollection) {
        super(paramCollection);
    }

    public DelayedVectorProxy(int paramInt1, int paramInt2) {
        super(paramInt1, paramInt2);
    }

    @Override
    public void setOwner(OpenJPAStateManager paramOpenJPAStateManager, int paramInt) {
        if (this.sm != null && this.detaching(paramOpenJPAStateManager, paramInt)) {
            this._detached = true;
            this._delayedSm = this.sm;
            this._delayedField = this.field;
        } else {
            this._detached = false;
        }
        this.sm = paramOpenJPAStateManager;
        if (this.sm != null && this.sm.getPersistenceCapable() != null) {
            this._ownerSm = (OpenJPAStateManager)this.sm.getPersistenceCapable().pcGetStateManager();
        }
        this.field = paramInt;
        if (this.sm != null && this.sm.getContext() != null) {
            this._brokerFactory = this.sm.getContext().getBroker().getBrokerFactory();
        }
    }

    private boolean detaching(OpenJPAStateManager paramOpenJPAStateManager, int paramInt) {
        return paramOpenJPAStateManager == null && paramInt == -1 || paramOpenJPAStateManager != null && paramOpenJPAStateManager instanceof DetachedStateManager;
    }

    @Override
    public int getDelayedField() {
        if (this.field == -1 || this._detached) {
            return this._delayedField;
        }
        return this.field;
    }

    @Override
    public OpenJPAStateManager getDelayedOwner() {
        if (this.sm == null || this._detached) {
            return this._delayedSm;
        }
        return this.sm;
    }

    @Override
    public OpenJPAStateManager getOwner() {
        return this.sm;
    }

    @Override
    public int getOwnerField() {
        return this.field;
    }

    @Override
    public boolean isDirectAccess() {
        return this._directAccess;
    }

    @Override
    public void setDirectAccess(boolean direct) {
        this._directAccess = direct;
    }

    public BrokerFactory getBrokerFactory() {
        return this._brokerFactory;
    }

    @Override
    public void load() {
        ProxyCollections.loadCollection(this);
    }

    @Override
    public Broker getBroker() {
        if ((this._broker == null || this._broker.isClosed()) && this._brokerFactory != null) {
            this._broker = this._brokerFactory.newBroker();
        }
        return this._broker;
    }

    @Override
    public void closeBroker() {
        if (this._broker != null && !this._broker.isClosed()) {
            this._broker.setAutoDetach(2);
            this._broker.close();
            this._broker = null;
        }
    }

    @Override
    public OpenJPAStateManager getOwnerStateManager() {
        return this._ownerSm;
    }

    @Override
    public boolean isDetached() {
        return this._detached;
    }

    public boolean isDelayLoad() {
        return ProxyCollections.isDelayed(this);
    }

    @Override
    public synchronized Object clone() {
        if (this.isDirectAccess()) {
            return super.clone();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Proxy localProxy = (Proxy)super.clone();
        localProxy.setOwner(null, 0);
        return localProxy;
    }

    @Override
    public ChangeTracker getChangeTracker() {
        return this.changeTracker;
    }

    protected void setChangeTracker(CollectionChangeTracker ct) {
        this.changeTracker = ct;
    }

    @Override
    public Object copy(Object paramObject) {
        if (this.isDelayLoad()) {
            this.load();
        }
        return new Vector((Collection)paramObject);
    }

    @Override
    public Class getElementType() {
        return this.elementType;
    }

    protected void setElementType(Class<?> elemType) {
        this.elementType = elemType;
    }

    @Override
    public ProxyCollection newInstance(Class paramClass, Comparator paramComparator, boolean paramBoolean1, boolean paramBoolean2) {
        DelayedVectorProxy localproxy = new DelayedVectorProxy();
        localproxy.elementType = paramClass;
        if (paramBoolean1) {
            localproxy.changeTracker = new DelayedCollectionChangeTrackerImpl(localproxy, true, true, paramBoolean2);
        }
        return localproxy;
    }

    @Override
    public synchronized boolean add(Object paramObject) {
        if (this._directAccess) {
            return super.add(paramObject);
        }
        ProxyCollections.beforeAdd(this, paramObject);
        boolean bool = super.add(paramObject);
        return ProxyCollections.afterAdd(this, paramObject, bool);
    }

    @Override
    public synchronized void add(int paramInt, Object paramObject) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeAdd(this, paramInt, paramObject);
        super.add(paramInt, paramObject);
    }

    @Override
    public void clear() {
        if (!this._directAccess) {
            if (this.isDelayLoad()) {
                this.load();
            }
            ProxyCollections.beforeClear(this);
        }
        super.clear();
    }

    @Override
    public synchronized boolean addAll(int paramInt, Collection paramCollection) {
        if (this._directAccess) {
            return super.addAll(paramInt, paramCollection);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        return ProxyCollections.addAll(this, paramInt, paramCollection);
    }

    @Override
    public synchronized boolean addAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.addAll(paramCollection);
        }
        return ProxyCollections.addAll(this, paramCollection);
    }

    public synchronized void addElement(Object paramObject) {
        if (this._directAccess) {
            super.addElement(paramObject);
            return;
        }
        ProxyCollections.beforeAddElement(this, paramObject);
        super.addElement(paramObject);
        ProxyCollections.afterAddElement(this, paramObject);
    }

    @Override
    public synchronized Object remove(int paramInt) {
        if (this._directAccess) {
            return super.remove(paramInt);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeRemove((ProxyCollection)this, paramInt);
        Object localObject = super.remove(paramInt);
        return ProxyCollections.afterRemove((ProxyCollection)this, paramInt, localObject);
    }

    @Override
    public synchronized boolean remove(Object paramObject) {
        if (this._directAccess) {
            return super.remove(paramObject);
        }
        ProxyCollections.beforeRemove((ProxyCollection)this, paramObject);
        this.setDirectAccess(true);
        boolean bool = super.remove(paramObject);
        this.setDirectAccess(false);
        return ProxyCollections.afterRemove((ProxyCollection)this, paramObject, bool);
    }

    @Override
    public synchronized Object set(int paramInt, Object paramObject) {
        if (this._directAccess) {
            return super.set(paramInt, paramObject);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeSet(this, paramInt, paramObject);
        Object localObject = super.set(paramInt, paramObject);
        return ProxyCollections.afterSet(this, paramInt, paramObject, localObject);
    }

    @Override
    public synchronized boolean removeAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.removeAll(paramCollection);
        }
        return ProxyCollections.removeAll(this, paramCollection);
    }

    @Override
    public synchronized boolean retainAll(Collection paramCollection) {
        if (this._directAccess) {
            return super.retainAll(paramCollection);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        return ProxyCollections.retainAll(this, paramCollection);
    }

    public synchronized void insertElementAt(Object paramObject, int paramInt) {
        if (this._directAccess) {
            super.insertElementAt(paramObject, paramInt);
            return;
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeInsertElementAt(this, paramObject, paramInt);
        super.insertElementAt(paramObject, paramInt);
    }

    @Override
    public synchronized void removeAllElements() {
        if (this._directAccess) {
            super.removeAllElements();
            return;
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeRemoveAllElements(this);
        super.removeAllElements();
    }

    @Override
    public synchronized boolean removeElement(Object paramObject) {
        if (this._directAccess) {
            return super.removeElement(paramObject);
        }
        ProxyCollections.beforeRemoveElement(this, paramObject);
        this.setDirectAccess(true);
        boolean bool = super.removeElement(paramObject);
        this.setDirectAccess(false);
        return ProxyCollections.afterRemoveElement(this, paramObject, bool);
    }

    @Override
    public synchronized void removeElementAt(int paramInt) {
        if (this._directAccess) {
            super.removeElementAt(paramInt);
            return;
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeRemoveElementAt(this, paramInt);
        super.removeElementAt(paramInt);
    }

    public synchronized void setElementAt(Object paramObject, int paramInt) {
        if (this._directAccess) {
            super.setElementAt(paramObject, paramInt);
            return;
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ProxyCollections.beforeSetElementAt(this, paramObject, paramInt);
        super.setElementAt(paramObject, paramInt);
    }

    @Override
    public Iterator iterator() {
        if (this._directAccess) {
            return super.iterator();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Iterator localIterator = super.iterator();
        return ProxyCollections.afterIterator(this, localIterator);
    }

    @Override
    public ListIterator listIterator(int paramInt) {
        if (this._directAccess) {
            return super.listIterator(paramInt);
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ListIterator localListIterator = super.listIterator(paramInt);
        return ProxyCollections.afterListIterator(this, paramInt, localListIterator);
    }

    @Override
    public ListIterator listIterator() {
        if (this._directAccess) {
            return super.listIterator();
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        ListIterator localListIterator = super.listIterator();
        return ProxyCollections.afterListIterator(this, localListIterator);
    }

    @Override
    public synchronized void setSize(int paramInt) {
        if (this._directAccess) {
            super.setSize(paramInt);
            return;
        }
        if (this.isDelayLoad()) {
            this.load();
        }
        Proxies.dirty(this, true);
        super.setSize(paramInt);
    }

    protected synchronized Object writeReplace() throws ObjectStreamException {
        if (this.isDelayLoad()) {
            this.load();
        }
        return Proxies.writeReplace(this, true);
    }

    @Override
    public synchronized boolean contains(Object object) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.contains(object);
    }

    @Override
    public synchronized boolean containsAll(Collection collection) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.containsAll(collection);
    }

    @Override
    public synchronized boolean isEmpty() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.isEmpty();
    }

    @Override
    public synchronized int size() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.size();
    }

    @Override
    public synchronized Object[] toArray() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray();
    }

    @Override
    public synchronized Object[] toArray(Object[] array) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray(array);
    }

    public Object[] toArray(IntFunction generator) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toArray(generator);
    }

    @Override
    public synchronized boolean equals(Object paramObject) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.equals(paramObject);
    }

    @Override
    public synchronized int hashCode() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.hashCode();
    }

    @Override
    public synchronized int lastIndexOf(Object object) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.lastIndexOf(object);
    }

    @Override
    public synchronized List subList(int start, int end) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.subList(start, end);
    }

    @Override
    public synchronized Object get(int location) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.get(location);
    }

    @Override
    public synchronized int indexOf(Object object) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.indexOf(object);
    }

    @Override
    public synchronized int indexOf(Object object, int index) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.indexOf(object, index);
    }

    @Override
    public synchronized void copyInto(Object[] anArray) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        super.copyInto(anArray);
    }

    @Override
    public synchronized void trimToSize() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        super.trimToSize();
    }

    @Override
    public synchronized void ensureCapacity(int minCapacity) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        super.ensureCapacity(minCapacity);
    }

    @Override
    public synchronized int capacity() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.capacity();
    }

    public Enumeration elements() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.elements();
    }

    @Override
    public synchronized int lastIndexOf(Object o, int index) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.lastIndexOf(o, index);
    }

    public synchronized Object elementAt(int index) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.elementAt(index);
    }

    public synchronized Object firstElement() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.firstElement();
    }

    public synchronized Object lastElement() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.lastElement();
    }

    @Override
    public synchronized String toString() {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        return super.toString();
    }

    @Override
    protected synchronized void removeRange(int fromIndex, int toIndex) {
        if (!this._directAccess && this.isDelayLoad()) {
            this.load();
        }
        super.removeRange(fromIndex, toIndex);
    }
}

