/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.webbeans.newtests.injection.unused;

import org.junit.Assert;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;

/**
 * producer of our unused bean
 */
public class UnusedBeanProducer
{
    public static boolean failed = false;

    @Produces @RequestScoped
    public UnusedBean createUnusedBean()
    {
        return new UnusedBean();
    }

    public void dispose(@Disposes UnusedBean unusedBean)
    {
        failed = true;
        Assert.fail("we should not dispose not-created beans ;)");
    }
}
