/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.inject.Named;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.ProducerFieldBeanBuilder;
import org.apache.webbeans.component.creation.ResourceBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerFieldBeansBuilder<T, I extends InjectionTargetBean<T>> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;

    public ProducerFieldBeansBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(webBeansContext, "webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, "annotated type may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public Set<ProducerFieldBean<?>> defineProducerFields(InjectionTargetBean<T> bean) {
        HashSet producerBeans = new HashSet();
        Set annotatedFields = this.annotatedType.getFields();
        for (AnnotatedField annotatedField : annotatedFields) {
            if (!annotatedField.isAnnotationPresent(Produces.class) || !annotatedField.getJavaMember().getDeclaringClass().equals(this.annotatedType.getJavaClass())) continue;
            Type genericType = annotatedField.getBaseType();
            if (ClassUtil.isTypeVariable(genericType)) {
                throw new WebBeansConfigurationException("Producer annotated field : " + annotatedField + " can not be Wildcard type or Type variable");
            }
            if (ClassUtil.isParametrizedType(genericType) && !ClassUtil.checkParametrizedType((ParameterizedType)genericType)) {
                throw new WebBeansConfigurationException("Producer annotated field : " + annotatedField + " can not be Wildcard type or Type variable");
            }
            Annotation[] anns = AnnotationUtil.asArray(annotatedField.getAnnotations());
            Field field = annotatedField.getJavaMember();
            Annotation resourceAnnotation = AnnotationUtil.hasOwbInjectableResource(anns);
            if (resourceAnnotation != null) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                ResourceReference resourceRef = new ResourceReference(this.annotatedType.getJavaClass(), field.getName(), field.getType(), resourceAnnotation);
                if (annotatedField.isAnnotationPresent(Named.class)) {
                    throw new WebBeansConfigurationException("Resource producer annotated field : " + annotatedField + " can not define EL name");
                }
                BeanAttributesImpl beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedField).build();
                ResourceBeanBuilder resourceBeanCreator = new ResourceBeanBuilder(bean, resourceRef, annotatedField, beanAttributes);
                ResourceBean resourceBean = (ResourceBean)resourceBeanCreator.getBean();
                resourceBean.setProducerField(field);
                producerBeans.add(resourceBean);
                continue;
            }
            BeanAttributesImpl beanAttributes = BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedField).build();
            ProducerFieldBeanBuilder producerFieldBeanCreator = new ProducerFieldBeanBuilder(bean, annotatedField, beanAttributes);
            Object producerFieldBean = producerFieldBeanCreator.getBean();
            this.webBeansContext.getDeploymentValidationService().validateProxyable((OwbBean<?>)producerFieldBean);
            ((ProducerFieldBean)producerFieldBean).setProducerField(field);
            this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(bean, (AbstractProducerBean<?>)producerFieldBean, anns);
            WebBeansUtil.checkProducerGenericType(producerFieldBean, annotatedField.getJavaMember());
            producerBeans.add((ProducerFieldBean<?>)producerFieldBean);
        }
        return producerBeans;
    }
}

