/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BrowseRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 527;
  }

  // Properties.
  protected final RequestHeader requestHeader;
  protected final ViewDescription view;
  protected final long requestedMaxReferencesPerNode;
  protected final List<BrowseDescription> nodesToBrowse;

  public BrowseRequest(
      RequestHeader requestHeader,
      ViewDescription view,
      long requestedMaxReferencesPerNode,
      List<BrowseDescription> nodesToBrowse) {
    super();
    this.requestHeader = requestHeader;
    this.view = view;
    this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
    this.nodesToBrowse = nodesToBrowse;
  }

  public RequestHeader getRequestHeader() {
    return requestHeader;
  }

  public ViewDescription getView() {
    return view;
  }

  public long getRequestedMaxReferencesPerNode() {
    return requestedMaxReferencesPerNode;
  }

  public List<BrowseDescription> getNodesToBrowse() {
    return nodesToBrowse;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BrowseRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, writeComplex(writeBuffer));

    // Simple Field (view)
    writeSimpleField("view", view, writeComplex(writeBuffer));

    // Simple Field (requestedMaxReferencesPerNode)
    writeSimpleField(
        "requestedMaxReferencesPerNode",
        requestedMaxReferencesPerNode,
        writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfNodesToBrowse) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfNodesToBrowse =
        (int) ((((getNodesToBrowse()) == (null)) ? -(1) : COUNT(getNodesToBrowse())));
    writeImplicitField("noOfNodesToBrowse", noOfNodesToBrowse, writeSignedInt(writeBuffer, 32));

    // Array Field (nodesToBrowse)
    writeComplexTypeArrayField("nodesToBrowse", nodesToBrowse, writeBuffer);

    writeBuffer.popContext("BrowseRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BrowseRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (view)
    lengthInBits += view.getLengthInBits();

    // Simple field (requestedMaxReferencesPerNode)
    lengthInBits += 32;

    // Implicit Field (noOfNodesToBrowse)
    lengthInBits += 32;

    // Array field
    if (nodesToBrowse != null) {
      int i = 0;
      for (BrowseDescription element : nodesToBrowse) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= nodesToBrowse.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("BrowseRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    RequestHeader requestHeader =
        readSimpleField(
            "requestHeader",
            readComplex(
                () ->
                    (RequestHeader) ExtensionObjectDefinition.staticParse(readBuffer, (int) (391)),
                readBuffer));

    ViewDescription view =
        readSimpleField(
            "view",
            readComplex(
                () ->
                    (ViewDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (513)),
                readBuffer));

    long requestedMaxReferencesPerNode =
        readSimpleField("requestedMaxReferencesPerNode", readUnsignedLong(readBuffer, 32));

    int noOfNodesToBrowse = readImplicitField("noOfNodesToBrowse", readSignedInt(readBuffer, 32));

    List<BrowseDescription> nodesToBrowse =
        readCountArrayField(
            "nodesToBrowse",
            readComplex(
                () ->
                    (BrowseDescription)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (516)),
                readBuffer),
            noOfNodesToBrowse);

    readBuffer.closeContext("BrowseRequest");
    // Create the instance
    return new BrowseRequestBuilderImpl(
        requestHeader, view, requestedMaxReferencesPerNode, nodesToBrowse);
  }

  public static class BrowseRequestBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final RequestHeader requestHeader;
    private final ViewDescription view;
    private final long requestedMaxReferencesPerNode;
    private final List<BrowseDescription> nodesToBrowse;

    public BrowseRequestBuilderImpl(
        RequestHeader requestHeader,
        ViewDescription view,
        long requestedMaxReferencesPerNode,
        List<BrowseDescription> nodesToBrowse) {
      this.requestHeader = requestHeader;
      this.view = view;
      this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
      this.nodesToBrowse = nodesToBrowse;
    }

    public BrowseRequest build() {
      BrowseRequest browseRequest =
          new BrowseRequest(requestHeader, view, requestedMaxReferencesPerNode, nodesToBrowse);
      return browseRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BrowseRequest)) {
      return false;
    }
    BrowseRequest that = (BrowseRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getView() == that.getView())
        && (getRequestedMaxReferencesPerNode() == that.getRequestedMaxReferencesPerNode())
        && (getNodesToBrowse() == that.getNodesToBrowse())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getView(),
        getRequestedMaxReferencesPerNode(),
        getNodesToBrowse());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
