/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.s7.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class S7MessageObjectRequest extends S7DataAlarmMessage implements Message {

  // Accessors for discriminator values.
  public Byte getCpuFunctionType() {
    return (byte) 0x04;
  }

  // Constant values.
  public static final Short VARIABLESPEC = 0x12;
  public static final Short LENGTH = 0x08;

  // Properties.
  protected final SyntaxIdType syntaxId;
  protected final QueryType queryType;
  protected final AlarmType alarmType;

  public S7MessageObjectRequest(SyntaxIdType syntaxId, QueryType queryType, AlarmType alarmType) {
    super();
    this.syntaxId = syntaxId;
    this.queryType = queryType;
    this.alarmType = alarmType;
  }

  public SyntaxIdType getSyntaxId() {
    return syntaxId;
  }

  public QueryType getQueryType() {
    return queryType;
  }

  public AlarmType getAlarmType() {
    return alarmType;
  }

  public short getVariableSpec() {
    return VARIABLESPEC;
  }

  public short getLength() {
    return LENGTH;
  }

  @Override
  protected void serializeS7DataAlarmMessageChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("S7MessageObjectRequest");

    // Const Field (variableSpec)
    writeConstField("variableSpec", VARIABLESPEC, writeUnsignedShort(writeBuffer, 8));

    // Const Field (length)
    writeConstField("length", LENGTH, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (syntaxId)
    writeSimpleEnumField(
        "syntaxId",
        "SyntaxIdType",
        syntaxId,
        writeEnum(SyntaxIdType::getValue, SyntaxIdType::name, writeUnsignedShort(writeBuffer, 8)));

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x00, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (queryType)
    writeSimpleEnumField(
        "queryType",
        "QueryType",
        queryType,
        writeEnum(QueryType::getValue, QueryType::name, writeUnsignedShort(writeBuffer, 8)));

    // Reserved Field (reserved)
    writeReservedField("reserved", (short) 0x34, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (alarmType)
    writeSimpleEnumField(
        "alarmType",
        "AlarmType",
        alarmType,
        writeEnum(AlarmType::getValue, AlarmType::name, writeUnsignedShort(writeBuffer, 8)));

    writeBuffer.popContext("S7MessageObjectRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    S7MessageObjectRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (variableSpec)
    lengthInBits += 8;

    // Const Field (length)
    lengthInBits += 8;

    // Simple field (syntaxId)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (queryType)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Simple field (alarmType)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static S7DataAlarmMessageBuilder staticParseS7DataAlarmMessageBuilder(
      ReadBuffer readBuffer, Byte cpuFunctionType) throws ParseException {
    readBuffer.pullContext("S7MessageObjectRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short variableSpec =
        readConstField(
            "variableSpec", readUnsignedShort(readBuffer, 8), S7MessageObjectRequest.VARIABLESPEC);

    short length =
        readConstField("length", readUnsignedShort(readBuffer, 8), S7MessageObjectRequest.LENGTH);

    SyntaxIdType syntaxId =
        readEnumField(
            "syntaxId",
            "SyntaxIdType",
            readEnum(SyntaxIdType::enumForValue, readUnsignedShort(readBuffer, 8)));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x00);

    QueryType queryType =
        readEnumField(
            "queryType",
            "QueryType",
            readEnum(QueryType::enumForValue, readUnsignedShort(readBuffer, 8)));

    Short reservedField1 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 8), (short) 0x34);

    AlarmType alarmType =
        readEnumField(
            "alarmType",
            "AlarmType",
            readEnum(AlarmType::enumForValue, readUnsignedShort(readBuffer, 8)));

    readBuffer.closeContext("S7MessageObjectRequest");
    // Create the instance
    return new S7MessageObjectRequestBuilderImpl(syntaxId, queryType, alarmType);
  }

  public static class S7MessageObjectRequestBuilderImpl
      implements S7DataAlarmMessage.S7DataAlarmMessageBuilder {
    private final SyntaxIdType syntaxId;
    private final QueryType queryType;
    private final AlarmType alarmType;

    public S7MessageObjectRequestBuilderImpl(
        SyntaxIdType syntaxId, QueryType queryType, AlarmType alarmType) {
      this.syntaxId = syntaxId;
      this.queryType = queryType;
      this.alarmType = alarmType;
    }

    public S7MessageObjectRequest build() {
      S7MessageObjectRequest s7MessageObjectRequest =
          new S7MessageObjectRequest(syntaxId, queryType, alarmType);
      return s7MessageObjectRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof S7MessageObjectRequest)) {
      return false;
    }
    S7MessageObjectRequest that = (S7MessageObjectRequest) o;
    return (getSyntaxId() == that.getSyntaxId())
        && (getQueryType() == that.getQueryType())
        && (getAlarmType() == that.getAlarmType())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getSyntaxId(), getQueryType(), getAlarmType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
