/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001 World Wide Web Consortium,
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level2.core;


import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.w3c.dom.CharacterData;
import org.w3c.dom.*;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.w3c.domts.DOMTest.load;


/**
 * The importNode method imports a node from another document to this document.
 * The returned node has no parent; (parentNode is null). The source node is not
 * altered or removed from the original document but a new copy of the source node
 * is created.
 * Using the method importNode with deep=true, import a entity node ent4
 * from this document to a new document object.  The replacement text of this entity is an element
 * node, a cdata node and a pi.  Verify if the nodes have been
 * imported correctly by checking the nodeNames of the imported element node, the data for the
 * cdata nodes and the PItarget and PIData for the pi nodes.
 *
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core">http://www.w3.org/TR/DOM-Level-2-Core/core</a>
 * @see <a href="http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode">http://www.w3.org/TR/DOM-Level-2-Core/core#Core-Document-importNode</a>
 */
public class documentimportnode20 {
    @Test
    @Disabled
    public void testRun() throws Throwable {
        DocumentType docTypeNull = null;
        Document doc = load("staffNS", true);
        DOMImplementation domImpl = doc.getImplementation();
        DocumentType docType = doc.getDoctype();
        Document docImp = domImpl.createDocument("http://www.w3.org/DOM/Test", "a:b", docTypeNull);
        NamedNodeMap nodeMap = docType.getEntities();
        Entity entity4 = (Entity) nodeMap.getNamedItem("ent4");
        Entity entityImp4 = (Entity) docImp.importNode(entity4, true);
        NodeList childList = entityImp4.getChildNodes();
        Element element = (Element) childList.item(0);
        NodeList elemchildList = element.getChildNodes();
        CharacterData cdata = (CharacterData) elemchildList.item(0);
        ProcessingInstruction pi = (ProcessingInstruction) childList.item(1);
        String ent4Name = entity4.getNodeName();
        String ent4ImpName = entityImp4.getNodeName();
        String cdataVal = cdata.getData();
        String piTargetVal = pi.getTarget();
        String piDataVal = pi.getData();
        assertEquals("documentimportnode20_Ent4NodeName", ent4Name, ent4ImpName);
        assertEquals("documentimportnode20_Cdata", "Element data", cdataVal);
        assertEquals("documentimportnode20_PITarget", "PItarget", piTargetVal);
        assertEquals("documentimportnode20_PIData", "PIdata", piDataVal);
    }

    /**
     * Gets URI that identifies the test
     *
     * @return uri identifier of test
     */
    public String getTargetURI() {
        return "http://www.w3.org/2001/DOM-Test-Suite/level2/core/documentimportnode20";
    }

}
