/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.example;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.rocketmq.client.apis.ClientException;
import org.apache.rocketmq.client.apis.ClientServiceProvider;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.producer.Producer;
import org.apache.rocketmq.client.java.example.ProducerSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProducerExample {
    private static final Logger log = LoggerFactory.getLogger(AsyncProducerExample.class);

    private AsyncProducerExample() {
    }

    public static void main(String[] args) throws ClientException, InterruptedException {
        ClientServiceProvider provider = ClientServiceProvider.loadService();
        String topic = "yourTopic";
        Producer producer = ProducerSingleton.getInstance(topic);
        byte[] body = "This is a normal message for Apache RocketMQ".getBytes(StandardCharsets.UTF_8);
        String tag = "yourMessageTagA";
        Message message = provider.newMessageBuilder().setTopic(topic).setTag(tag).setKeys(new String[]{"yourMessageKey-0e094a5f9d85"}).setBody(body).build();
        CompletableFuture future = producer.sendAsync(message);
        ExecutorService sendCallbackExecutor = Executors.newCachedThreadPool();
        future.whenCompleteAsync((sendReceipt, throwable) -> {
            if (null != throwable) {
                log.error("Failed to send message", throwable);
                return;
            }
            log.info("Send message successfully, messageId={}", (Object)sendReceipt.getMessageId());
        }, (Executor)sendCallbackExecutor);
        Thread.sleep(Long.MAX_VALUE);
    }
}

