/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.util;

import com.netflix.zuul.context.RequestContext;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class HTTPRequestUtils {
    private static final HTTPRequestUtils INSTANCE = new HTTPRequestUtils();
    public static final String X_FORWARDED_FOR_HEADER = "x-forwarded-for";

    public String getClientIP(HttpServletRequest request) {
        String xForwardedFor = request.getHeader(X_FORWARDED_FOR_HEADER);
        String clientIP = null;
        clientIP = xForwardedFor == null ? request.getRemoteAddr() : this.extractClientIpFromXForwardedFor(xForwardedFor);
        return clientIP;
    }

    public final String extractClientIpFromXForwardedFor(String xForwardedFor) {
        if (xForwardedFor == null) {
            return null;
        }
        String[] tokenized = (xForwardedFor = xForwardedFor.trim()).split(",");
        if (tokenized.length == 0) {
            return null;
        }
        return tokenized[0].trim();
    }

    public static HTTPRequestUtils getInstance() {
        return INSTANCE;
    }

    public String getHeaderValue(String sHeaderName) {
        return RequestContext.getCurrentContext().getRequest().getHeader(sHeaderName);
    }

    public String getFormValue(String sHeaderName) {
        return RequestContext.getCurrentContext().getRequest().getParameter(sHeaderName);
    }

    public Map<String, List<String>> getRequestHeaderMap() {
        HttpServletRequest request = RequestContext.getCurrentContext().getRequest();
        HashMap headers = new HashMap();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                String value = request.getHeader(name);
                if (name == null || name.isEmpty() || value == null) continue;
                ArrayList<String> valueList = new ArrayList<String>();
                if (headers.containsKey(name)) {
                    ((List)headers.get(name)).add(value);
                }
                valueList.add(value);
                headers.put(name, valueList);
            }
        }
        return Collections.unmodifiableMap(headers);
    }

    public Map<String, List<String>> getQueryParams() {
        Map<String, List<String>> qp = RequestContext.getCurrentContext().getRequestQueryParams();
        if (qp != null) {
            return qp;
        }
        HttpServletRequest request = RequestContext.getCurrentContext().getRequest();
        qp = new HashMap<String, List<String>>();
        if (request.getQueryString() == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(request.getQueryString(), "&");
        while (st.hasMoreTokens()) {
            List<String> valueList;
            String value;
            String name;
            String s = st.nextToken();
            int i = s.indexOf("=");
            if (i > 0 && s.length() >= i + 1) {
                name = s.substring(0, i);
                value = s.substring(i + 1);
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                valueList = qp.get(name);
                if (valueList == null) {
                    valueList = new LinkedList<String>();
                    qp.put(name, valueList);
                }
                valueList.add(value);
                continue;
            }
            if (i != -1) continue;
            name = s;
            value = "";
            try {
                name = URLDecoder.decode(name, "UTF-8");
            }
            catch (Exception valueList2) {
                // empty catch block
            }
            valueList = qp.get(name);
            if (valueList == null) {
                valueList = new LinkedList<String>();
                qp.put(name, valueList);
            }
            valueList.add(value);
        }
        RequestContext.getCurrentContext().setRequestQueryParams(qp);
        return qp;
    }

    public String getValueFromRequestElements(String sName) {
        List<String> v;
        String sValue = null;
        if (this.getQueryParams() != null && (v = this.getQueryParams().get(sName)) != null && !v.isEmpty()) {
            sValue = v.iterator().next();
        }
        if (sValue != null) {
            return sValue;
        }
        sValue = this.getHeaderValue(sName);
        if (sValue != null) {
            return sValue;
        }
        sValue = this.getFormValue(sName);
        if (sValue != null) {
            return sValue;
        }
        return null;
    }

    public boolean isGzipped(String contentEncoding) {
        return contentEncoding.contains("gzip");
    }

    public static class UnitTest {
        @Mock
        private RequestContext mockContext;
        @Mock
        private HttpServletRequest request;

        @Before
        public void before() {
            MockitoAnnotations.initMocks((Object)this);
        }

        @Test
        public void detectsGzip() {
            Assert.assertTrue((boolean)HTTPRequestUtils.getInstance().isGzipped("gzip"));
        }

        @Test
        public void detectsNonGzip() {
            Assert.assertFalse((boolean)HTTPRequestUtils.getInstance().isGzipped("identity"));
        }

        @Test
        public void detectsGzipAmongOtherEncodings() {
            Assert.assertTrue((boolean)HTTPRequestUtils.getInstance().isGzipped("gzip, deflate"));
        }

        @Test
        public void testGetQueryParams() {
            LinkedList<String> blankValue = new LinkedList<String>();
            blankValue.add("");
            RequestContext.testSetCurrentContext(this.mockContext);
            Mockito.when(this.mockContext.getRequestQueryParams()).thenReturn(null);
            Mockito.when((Object)this.mockContext.getRequest()).thenReturn((Object)this.request);
            Mockito.when((Object)this.request.getQueryString()).thenReturn((Object)"wsdl");
            Map<String, List<String>> qp = HTTPRequestUtils.getInstance().getQueryParams();
            Assert.assertEquals(blankValue, qp.get("wsdl"));
            Mockito.when((Object)this.request.getQueryString()).thenReturn((Object)"wsdl=");
            qp = HTTPRequestUtils.getInstance().getQueryParams();
            Assert.assertEquals(blankValue, qp.get("wsdl"));
            Mockito.when((Object)this.request.getQueryString()).thenReturn((Object)"a=123&b=234&b=345&c&d=");
            qp = HTTPRequestUtils.getInstance().getQueryParams();
            Assert.assertEquals((Object)"123", (Object)qp.get("a").get(0));
            Assert.assertEquals((Object)"234", (Object)qp.get("b").get(0));
            Assert.assertEquals((Object)"345", (Object)qp.get("b").get(1));
            Assert.assertEquals(blankValue, qp.get("c"));
            Assert.assertEquals(blankValue, qp.get("d"));
        }
    }
}

