/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.export;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.export.AbstractMetricExporter;
import org.springframework.boot.actuate.metrics.reader.PrefixMetricReader;
import org.springframework.boot.actuate.metrics.repository.MultiMetricRepository;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.PrefixMetricWriter;

public class PrefixMetricGroupExporter
extends AbstractMetricExporter {
    private final PrefixMetricReader reader;
    private final PrefixMetricWriter writer;
    private ConcurrentMap<String, Long> counts = new ConcurrentHashMap<String, Long>();
    private Set<String> groups = new HashSet<String>();

    public PrefixMetricGroupExporter(PrefixMetricReader reader, PrefixMetricWriter writer) {
        this(reader, writer, "");
    }

    public PrefixMetricGroupExporter(PrefixMetricReader reader, PrefixMetricWriter writer, String prefix) {
        super(prefix);
        this.reader = reader;
        this.writer = writer;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Override
    protected Iterable<String> groups() {
        if (this.reader instanceof MultiMetricRepository && this.groups.isEmpty()) {
            return ((MultiMetricRepository)this.reader).groups();
        }
        return this.groups;
    }

    @Override
    protected Iterable<Metric<?>> next(String group) {
        return this.reader.findAll(group);
    }

    @Override
    protected void write(String group, Collection<Metric<?>> values) {
        if (group.contains("counter.")) {
            for (Metric<?> value : values) {
                this.writer.increment(group, this.calculateDelta(value));
            }
        } else {
            this.writer.set(group, values);
        }
    }

    private Delta<?> calculateDelta(Metric<?> value) {
        long delta = ((Number)value.getValue()).longValue();
        Long old = this.counts.replace(value.getName(), delta);
        if (old != null) {
            delta -= old.longValue();
        } else {
            this.counts.putIfAbsent(value.getName(), delta);
        }
        return new Delta<Long>(value.getName(), delta, value.getTimestamp());
    }
}

