/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.metrics.metric;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.vertx.metrics.MetricsOptionsEx;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetric;

public class DefaultClientEndpointMetricManager {
    private final MetricsOptionsEx metricsOptionsEx;
    private final Map<String, DefaultClientEndpointMetric> clientEndpointMetricMap = new ConcurrentHashMapEx();
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();

    public DefaultClientEndpointMetricManager(MetricsOptionsEx metricsOptionsEx) {
        this.metricsOptionsEx = metricsOptionsEx;
    }

    public DefaultClientEndpointMetric getOrCreateEndpointMetric(String address) {
        this.rwlock.readLock().lock();
        try {
            DefaultClientEndpointMetric defaultClientEndpointMetric = this.clientEndpointMetricMap.computeIfAbsent(address, DefaultClientEndpointMetric::new);
            return defaultClientEndpointMetric;
        }
        finally {
            this.rwlock.readLock().unlock();
        }
    }

    @VisibleForTesting
    public DefaultClientEndpointMetric getClientEndpointMetric(String serverAddress) {
        return this.clientEndpointMetricMap.get(serverAddress);
    }

    public Map<String, DefaultClientEndpointMetric> getClientEndpointMetricMap() {
        return this.clientEndpointMetricMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void onCheckClientEndpointMetricExpired(long periodic) {
        for (DefaultClientEndpointMetric metric : this.clientEndpointMetricMap.values()) {
            if (!metric.isExpired(this.metricsOptionsEx.getCheckClientEndpointMetricExpiredInNano())) continue;
            this.rwlock.writeLock().lock();
            try {
                if (!metric.isExpired(this.metricsOptionsEx.getCheckClientEndpointMetricExpiredInNano())) continue;
                this.clientEndpointMetricMap.remove(metric.getAddress());
            }
            finally {
                this.rwlock.writeLock().unlock();
            }
        }
    }

    public void setVertx(Vertx vertx) {
        vertx.setPeriodic(this.metricsOptionsEx.getCheckClientEndpointMetricIntervalInMilliseconds(), this::onCheckClientEndpointMetricExpired);
    }
}

