/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.diagnosis.instance;

import com.google.common.eventbus.EventBus;
import com.netflix.config.DynamicIntProperty;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.serviceregistry.diagnosis.instance.InstanceCacheChecker;
import org.apache.servicecomb.serviceregistry.diagnosis.instance.InstanceCacheSummary;
import org.apache.servicecomb.serviceregistry.registry.RemoteServiceRegistry;
import org.apache.servicecomb.serviceregistry.registry.ServiceRegistryTaskInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceCacheCheckTask
implements ServiceRegistryTaskInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceCacheCheckTask.class);
    private static final int DEFAULT_DIAGNOSE_INSTANCE_CACHE_INTERVAL_IN_HOUR = 24;
    private static final String CONFIG_PREFIX = "servicecomb.service.registry.instance.diagnose.";
    public static final String MANUAL = "servicecomb.service.registry.instance.diagnose.manual";
    public static final String AUTO_INTERVAL = "servicecomb.service.registry.instance.diagnose.interval";
    private ScheduledFuture<?> scheduledFuture;
    private ScheduledThreadPoolExecutor taskPool;
    private EventBus eventBus;
    private DynamicIntProperty autoCheckIntervalProperty;
    private DynamicStringProperty manualCheckProperty;
    private TimeUnit timeUnit = TimeUnit.HOURS;

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setTaskPool(ScheduledThreadPoolExecutor taskPool) {
        this.taskPool = taskPool;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public DynamicStringProperty getManualCheckProperty() {
        return this.manualCheckProperty;
    }

    public DynamicIntProperty getAutoCheckIntervalProperty() {
        return this.autoCheckIntervalProperty;
    }

    @Override
    public void init(RemoteServiceRegistry remoteServiceRegistry) {
        this.taskPool = remoteServiceRegistry.getTaskPool();
        this.eventBus = remoteServiceRegistry.getEventBus();
        this.init();
    }

    protected void init() {
        this.startAutoTask();
        this.registerManualTask();
    }

    private void registerManualTask() {
        this.manualCheckProperty = DynamicPropertyFactory.getInstance().getStringProperty(MANUAL, null, this::runTask);
    }

    protected void startAutoTask() {
        this.autoCheckIntervalProperty = DynamicPropertyFactory.getInstance().getIntProperty(AUTO_INTERVAL, 24, this::doStartAutoTask);
        this.doStartAutoTask();
    }

    private void doStartAutoTask() {
        int interval;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
        if ((interval = this.autoCheckIntervalProperty.get()) <= 0) {
            LOGGER.info("disable instance cache check task, interval={}.", (Object)interval);
            return;
        }
        this.scheduledFuture = this.taskPool.scheduleAtFixedRate(this::runTask, interval, interval, this.timeUnit);
    }

    protected void runTask() {
        try {
            InstanceCacheChecker checker = new InstanceCacheChecker(DiscoveryManager.INSTANCE.getAppManager());
            InstanceCacheSummary instanceCacheSummary = checker.check();
            this.eventBus.post((Object)instanceCacheSummary);
            LOGGER.info("check instance cache, result={}.", (Object)instanceCacheSummary.getStatus());
        }
        catch (Throwable e) {
            LOGGER.error("failed check instance cache..", e);
        }
    }
}

