/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.publication;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.cms.PublishableResource;
import org.apache.sling.cms.core.publication.StandalonePublicationManager;
import org.apache.sling.cms.publication.PUBLICATION_MODE;
import org.apache.sling.cms.publication.PublicationException;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.DistributionResponse;
import org.apache.sling.distribution.Distributor;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentDistributionPublicationManager
extends StandalonePublicationManager {
    private static final Logger log = LoggerFactory.getLogger(ContentDistributionPublicationManager.class);
    private final Distributor distributor;
    private final String[] agents;

    public ContentDistributionPublicationManager(Distributor distributor, String[] agents, EventAdmin eventAdmin) {
        super(eventAdmin);
        this.distributor = distributor;
        this.agents = agents;
    }

    @Override
    public void publish(PublishableResource resource) throws PublicationException {
        log.info("Publishing: {}", (Object)resource.getPath());
        SimpleDistributionRequest request = new SimpleDistributionRequest(DistributionRequestType.ADD, new String[]{resource.getPath(), resource.getContentResource().getPath()}, Collections.singleton(resource.getContentResource().getPath()));
        List<DistributionResponse> failedResponses = this.distributeRequest(resource.getResource().getResourceResolver(), (DistributionRequest)request);
        if (!failedResponses.isEmpty()) {
            throw new PublicationException("Failed to publish: " + this.collectFailures(failedResponses));
        }
        log.debug("Content Distribution successful, updating publication information");
        super.publish(resource);
    }

    private String collectFailures(List<DistributionResponse> failedResponses) {
        return failedResponses.stream().map(r -> r.getState() + ": " + r.getMessage()).collect(Collectors.joining(",", "[", "]"));
    }

    private List<DistributionResponse> distributeRequest(ResourceResolver resolver, DistributionRequest request) {
        return Arrays.stream(this.agents).map(a -> {
            log.info("Sending to agent: {}", a);
            DistributionResponse response = this.distributor.distribute(a, resolver, request);
            log.debug("Retrieved response [{}]: {}", (Object)response.getState(), (Object)response.getMessage());
            return response;
        }).filter(res -> !res.isSuccessful()).collect(Collectors.toList());
    }

    @Override
    public void unpublish(PublishableResource resource) throws PublicationException {
        log.info("Unpublish: {}", (Object)resource.getPath());
        SimpleDistributionRequest request = new SimpleDistributionRequest(DistributionRequestType.DELETE, new String[]{resource.getPath(), resource.getContentResource().getPath()}, Collections.singleton(resource.getContentResource().getPath()));
        List<DistributionResponse> failedResponses = this.distributeRequest(resource.getResource().getResourceResolver(), (DistributionRequest)request);
        if (!failedResponses.isEmpty()) {
            throw new PublicationException("Failed to unpublish: " + this.collectFailures(failedResponses));
        }
        super.unpublish(resource);
    }

    @Override
    public PUBLICATION_MODE getPublicationMode() {
        return PUBLICATION_MODE.CONTENT_DISTRIBUTION;
    }
}

