/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sling.commons.crypto.PasswordProvider;
import org.apache.sling.commons.crypto.internal.FilePasswordProviderConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Commons Crypto \u2013 File Password Provider", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=FilePasswordProviderConfiguration.class, factory=true)
public final class FilePasswordProvider
implements PasswordProvider {
    private static final char NEWLINE_CHARACTER = '\n';
    private FilePasswordProviderConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(FilePasswordProvider.class);

    @Activate
    private void activate(FilePasswordProviderConfiguration configuration) throws IOException {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.checkConfiguration(configuration);
    }

    @Modified
    private void modified(FilePasswordProviderConfiguration configuration) throws IOException {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.checkConfiguration(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    private char[] readPassword(String path, boolean fixPosixNewline) throws IOException {
        File file = new File(path);
        this.checkPasswordFile(file);
        char[] buffer = new char[(int)file.length()];
        try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            int size = reader.read(buffer);
            int length = fixPosixNewline && buffer[size - 1] == '\n' ? size - 1 : size;
            char[] password = new char[length];
            System.arraycopy(buffer, 0, password, 0, length);
            Arrays.fill(buffer, '0');
            char[] cArray = password;
            return cArray;
        }
    }

    private void checkConfiguration(FilePasswordProviderConfiguration configuration) throws IOException {
        File file = new File(configuration.path());
        this.checkPasswordFile(file);
    }

    private void checkPasswordFile(File file) throws IOException {
        if (!file.canRead()) {
            String message = String.format("Unable to read password file '%s'", file.getAbsolutePath());
            throw new IOException(message);
        }
    }

    @Override
    public char @NotNull [] getPassword() {
        FilePasswordProviderConfiguration configuration = this.configuration;
        Objects.requireNonNull(configuration, "Configuration must not be null");
        try {
            return this.readPassword(configuration.path(), configuration.fix_posixNewline());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

