/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.contentparser.testutils.mapsupport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class ContentElement {
    private final String name;
    private final Map<String, Object> properties;
    private final Map<String, ContentElement> children = new LinkedHashMap<String, ContentElement>();

    ContentElement(String name, Map<String, Object> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, ContentElement> getChildren() {
        return this.children;
    }

    public ContentElement getChild(String path) {
        String childName = StringUtils.substringBefore((String)path, (String)"/");
        ContentElement child = this.children.get(childName);
        if (child == null) {
            return null;
        }
        String remainingPath = StringUtils.substringAfter((String)path, (String)"/");
        if (StringUtils.isEmpty((CharSequence)remainingPath)) {
            return child;
        }
        return child.getChild(remainingPath);
    }
}

