/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyzer.impl.felix.utils.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class StringArrayMap<V>
implements Map<String, V> {
    protected Object[] table;
    protected int size;

    public static <T> Map<String, T> reduceMemory(Map<String, T> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<String, T> e = map.entrySet().iterator().next();
                return Collections.singletonMap(e.getKey().intern(), e.getValue());
            }
        }
        if (map instanceof StringArrayMap) {
            StringArrayMap m = (StringArrayMap)map;
            if (m.size == m.table.length / 2) {
                return map;
            }
        }
        return new StringArrayMap<T>(map);
    }

    public StringArrayMap(Map<String, ? extends V> map) {
        if (map instanceof StringArrayMap) {
            this.size = ((StringArrayMap)map).size;
            this.table = Arrays.copyOf(((StringArrayMap)map).table, this.size * 2);
        } else {
            this.size = 0;
            this.table = new Object[map.size() * 2];
            for (Map.Entry<String, V> e : map.entrySet()) {
                int i = this.size++ << 1;
                this.table[i++] = e.getKey().intern();
                this.table[i] = e.getValue();
            }
        }
    }

    public StringArrayMap() {
        this(32);
    }

    public StringArrayMap(int capacity) {
        this.table = new Object[capacity * 2];
        this.size = 0;
    }

    @Override
    public V get(Object key) {
        String k = ((String)key).intern();
        int l = this.size << 1;
        for (int i = 0; i < l; i += 2) {
            if (k != this.table[i]) continue;
            return (V)this.table[i + 1];
        }
        return null;
    }

    @Override
    public V put(String key, V value) {
        return (V)this.doPut(key, value);
    }

    protected Object doPut(String key, Object value) {
        int i;
        key = key.intern();
        int l = this.size << 1;
        for (i = 0; i < l; i += 2) {
            if (key != this.table[i]) continue;
            Object old = this.table[i + 1];
            this.table[i + 1] = value;
            return old;
        }
        if (this.table.length == 0) {
            this.table = new Object[2];
        } else if (this.size * 2 == this.table.length) {
            Object[] n = new Object[this.table.length * 2];
            System.arraycopy(this.table, 0, n, 0, this.table.length);
            this.table = n;
        }
        i = this.size++ << 1;
        this.table[i++] = key;
        this.table[i] = value;
        return null;
    }

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < StringArrayMap.this.size;
                    }

                    @Override
                    public String next() {
                        if (this.index >= StringArrayMap.this.size) {
                            throw new NoSuchElementException();
                        }
                        return (String)StringArrayMap.this.table[this.index++ << 1];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }

            @Override
            public int size() {
                return StringArrayMap.this.size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < StringArrayMap.this.size;
                    }

                    @Override
                    public V next() {
                        if (this.index >= StringArrayMap.this.size) {
                            throw new NoSuchElementException();
                        }
                        return StringArrayMap.this.table[(this.index++ << 1) + 1];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }

            @Override
            public int size() {
                return StringArrayMap.this.size;
            }
        };
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new AbstractSet<Map.Entry<String, V>>(){

            @Override
            public Iterator<Map.Entry<String, V>> iterator() {
                return new Iterator<Map.Entry<String, V>>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < StringArrayMap.this.size;
                    }

                    @Override
                    public Map.Entry<String, V> next() {
                        if (this.index >= StringArrayMap.this.size) {
                            throw new NoSuchElementException();
                        }
                        final int i = this.index << 1;
                        ++this.index;
                        return new Map.Entry<String, V>(){

                            @Override
                            public String getKey() {
                                return (String)StringArrayMap.this.table[i];
                            }

                            @Override
                            public V getValue() {
                                return StringArrayMap.this.table[i + 1];
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                };
            }

            @Override
            public int size() {
                return StringArrayMap.this.size;
            }
        };
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        String k = ((String)key).intern();
        int l = this.size * 2;
        for (int i = 0; i < l; i += 2) {
            if (this.table[i] != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        int l = this.size * 2;
        for (int i = 0; i < l; i += 2) {
            if (!Objects.equals(this.table[i + 1], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        String k = ((String)key).intern();
        int l = this.size * 2;
        for (int i = 0; i < l; i += 2) {
            if (this.table[i] != k) continue;
            Object v = this.table[i + 1];
            if (i < l - 2) {
                System.arraycopy(this.table, i + 2, this.table, i, l - 2 - i);
            }
            this.table[l - 1] = null;
            this.table[l - 2] = null;
            --this.size;
            return (V)v;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.table, null);
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size * 2; ++i) {
            result = 31 * result + (this.table[i] == null ? 0 : this.table[i].hashCode());
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            int l = this.size * 2;
            for (int i = 0; i < l; i += 2) {
                Object key = this.table[i];
                Object value = this.table[i + 1];
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int l = this.size * 2;
        for (int i = 0; i < l; i += 2) {
            if (i > 0) {
                sb.append(',').append(' ');
            }
            sb.append(this.table[i]);
            sb.append('=');
            sb.append(this.table[i + 1] == this ? "(this Map)" : this.table[i + 1]);
        }
        return sb.append('}').toString();
    }
}

