/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav.model;

import de.pdark.decentxml.Element;
import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.eclipse.ui.nav.model.SyncDir;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (file == null) {
            return null;
        }
        IProject project = file.getProject();
        if (!ProjectHelper.isContentProject((IProject)project)) {
            return null;
        }
        IPath syncDirFullPath = ProjectUtil.getSyncDirectoryFullPath((IProject)project);
        if (syncDirFullPath == null) {
            return null;
        }
        if (!syncDirFullPath.isPrefixOf(file.getFullPath())) {
            return null;
        }
        JcrNode selectedNode = this.createSelectionNode((IResource)file);
        if (selectedNode != null) {
            return new StructuredSelection((Object)selectedNode);
        }
        return null;
    }

    private JcrNode createSelectionNode(IResource resource) {
        JcrNode parent;
        if (resource == null) {
            return null;
        }
        IContainer resourceParent = resource.getParent();
        if (resource instanceof IFolder) {
            IFolder container = (IFolder)resource;
            IPath syncDirFullPath = ProjectUtil.getSyncDirectoryFullPath((IProject)resource.getProject());
            if (syncDirFullPath.equals((Object)container.getFullPath())) {
                return new SyncDir(container);
            }
        } else if (!(resource instanceof IFile)) {
            return null;
        }
        if ((parent = this.createSelectionNode((IResource)resourceParent)) == null) {
            return null;
        }
        Element domNode = null;
        JcrNode selectedNode = new JcrNode(parent, domNode, resource);
        return selectedNode;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        Object selectedElement = aSelection.getFirstElement();
        if (!(selectedElement instanceof JcrNode)) {
            return;
        }
        JcrNode node = (JcrNode)selectedElement;
        IResource resource = node.getResource();
        if (resource == null || !(resource instanceof IFile)) {
            return;
        }
        IFile selectedFile = (IFile)resource;
        IEditorReference[] iEditorReferenceArray = aPage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                IEditorReference reference = iEditorReferenceArray[n2];
                if (reference != null) {
                    IFileEditorInput fileEditorInput;
                    IFile file;
                    IEditorInput editorInput;
                    try {
                        editorInput = reference.getEditorInput();
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                        break block7;
                    }
                    if (editorInput != null && editorInput instanceof IFileEditorInput && (file = (fileEditorInput = (IFileEditorInput)editorInput).getFile()) != null && file.equals((Object)selectedFile)) {
                        aPage.bringToTop((IWorkbenchPart)reference.getEditor(true));
                    }
                }
            }
            ++n2;
        }
    }
}

