/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Objects;
import java.util.TreeSet;

public class SortedDictionary<K, V>
extends Dictionary<K, V> {
    private final Dictionary<K, V> delegate;

    public SortedDictionary(Dictionary<K, V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Enumeration<K> keys() {
        return SortedDictionary.sortedEnumeration(this.delegate.keys());
    }

    @Override
    public Enumeration<V> elements() {
        Enumeration<K> sortedKeys = this.keys();
        ArrayList<V> sortedValues = new ArrayList<V>();
        while (sortedKeys.hasMoreElements()) {
            K key = sortedKeys.nextElement();
            sortedValues.add(this.delegate.get(key));
        }
        return Collections.enumeration(sortedValues);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedDictionary other = (SortedDictionary)obj;
        return Objects.equals(this.delegate, other.delegate);
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    public String toString() {
        return this.delegate.toString();
    }

    private static <T> Enumeration<T> sortedEnumeration(Enumeration<T> enumeration) {
        TreeSet<T> sortedSet = new TreeSet<T>();
        while (enumeration.hasMoreElements()) {
            sortedSet.add(enumeration.nextElement());
        }
        return Collections.enumeration(sortedSet);
    }
}

