/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.iterator;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.query.api.internal.Option;
import org.apache.sling.query.impl.iterator.AbstractIterator;

public class UniqueIterator<T>
extends AbstractIterator<Option<T>> {
    private Iterator<Option<T>> iterator;
    private Set<T> seen;

    public UniqueIterator(Iterator<Option<T>> input) {
        this.iterator = input;
        this.seen = new HashSet<T>();
    }

    @Override
    protected Option<T> getElement() {
        if (!this.iterator.hasNext()) {
            this.iterator = Collections.emptyIterator();
            this.seen = null;
            return null;
        }
        Option<T> candidate = this.iterator.next();
        if (!candidate.isEmpty() && !this.seen.add(candidate.getElement())) {
            return Option.empty(candidate.getArgumentId());
        }
        return candidate;
    }
}

