/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.bundle.tracker.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.apache.sling.scripting.api.BindingsValuesProvidersByContext;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.bundle.tracker.BundledRenderUnit;
import org.apache.sling.scripting.bundle.tracker.internal.BundledScriptContext;
import org.apache.sling.scripting.bundle.tracker.internal.Executable;
import org.apache.sling.scripting.bundle.tracker.internal.LazyBindings;
import org.apache.sling.scripting.bundle.tracker.internal.LogWriter;
import org.apache.sling.scripting.bundle.tracker.internal.ProtectedBindings;
import org.apache.sling.scripting.core.ScriptHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ScriptContextProvider.class})
public class ScriptContextProvider {
    private static final Set<String> PROTECTED_BINDINGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("request", "response", "reader", "resource", "resolver", "out", "log", "sling", "javax.script.filename", BundledRenderUnit.VARIABLE)));
    @Reference
    private BindingsValuesProvidersByContext bvpTracker;
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;

    ScriptContext prepareScriptContext(SlingHttpServletRequest request, SlingHttpServletResponse response, Executable executable) throws IOException {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("properties", (Object)request.getResource().getValueMap());
        bindings.put("request", (Object)request);
        bindings.put("response", (Object)response);
        bindings.put("reader", (Object)request.getReader());
        bindings.put("resource", (Object)request.getResource());
        bindings.put("resolver", (Object)request.getResource().getResourceResolver());
        bindings.put("out", (Object)response.getWriter());
        Logger scriptLogger = LoggerFactory.getLogger((String)executable.getName());
        bindings.put("log", (Object)scriptLogger);
        bindings.put("sling", (Object)new ScriptHelper(executable.getBundle().getBundleContext(), null, request, response));
        bindings.put(BundledRenderUnit.VARIABLE, (Object)executable);
        bindings.put("javax.script.filename", (Object)executable.getName());
        bindings.put("javax.script.filename".replaceAll("\\.", "_"), (Object)executable.getName());
        ProtectedBindings protectedBindings = new ProtectedBindings(bindings, PROTECTED_BINDINGS);
        for (BindingsValuesProvider bindingsValuesProvider : this.bvpTracker.getBindingsValuesProviders(executable.getScriptEngine().getFactory(), "request")) {
            bindingsValuesProvider.addBindings((Bindings)protectedBindings);
        }
        BundledScriptContext scriptContext = new BundledScriptContext();
        HashMap<String, Supplier<Object>> slingBindingsSuppliers = new HashMap<String, Supplier<Object>>();
        slingBindingsSuppliers.put("org.apache.sling.api.scripting.ScriptResourceResolver", () -> this.scriptingResourceResolverProvider.getRequestScopedResourceResolver());
        LazyBindings slingScopeBindings = new LazyBindings(Collections.unmodifiableMap(slingBindingsSuppliers));
        scriptContext.setBindings(slingScopeBindings, -314);
        scriptContext.setBindings(bindings, 100);
        scriptContext.setWriter(response.getWriter());
        scriptContext.setErrorWriter(new LogWriter(scriptLogger));
        scriptContext.setReader(request.getReader());
        return scriptContext;
    }
}

