/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.clients.osgi;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import org.apache.sling.testing.clients.exceptions.TestingValidationException;
import org.apache.sling.testing.clients.osgi.ServicesInfo;

public class ServiceInfo {
    private JsonNode service;

    public ServiceInfo(JsonNode root) throws TestingValidationException {
        if (root.get("id") != null) {
            this.service = root;
        } else {
            if (root.get("data") == null && root.get("data").size() < 1) {
                throw new TestingValidationException("No service info returned");
            }
            this.service = root.get("data").get(0);
        }
    }

    public int getId() {
        return Integer.parseInt(this.service.get("id").asText());
    }

    public List<String> getTypes() {
        return ServicesInfo.splitPseudoJsonValueArray(this.service.get("types").textValue());
    }

    public String getPid() {
        return this.service.get("pid").textValue();
    }

    public int getBundleId() {
        return this.service.get("bundleId").intValue();
    }

    public String getBundleSymbolicName() {
        return this.service.get("bundleSymbolicName").textValue();
    }
}

