/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.api.JackrabbitWorkspace;
import org.apache.jackrabbit.commons.AbstractWorkspace;
import org.apache.jackrabbit.core.BatchedItemOperations;
import org.apache.jackrabbit.core.CachingHierarchyManager;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.SearchManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.VersionManagerImpl;
import org.apache.jackrabbit.core.WorkspaceManager;
import org.apache.jackrabbit.core.XASessionImpl;
import org.apache.jackrabbit.core.config.WorkspaceConfig;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.lock.LockManager;
import org.apache.jackrabbit.core.lock.LockManagerImpl;
import org.apache.jackrabbit.core.lock.SessionLockManager;
import org.apache.jackrabbit.core.lock.XALockManager;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.observation.ObservationManagerImpl;
import org.apache.jackrabbit.core.query.QueryManagerImpl;
import org.apache.jackrabbit.core.retention.RetentionRegistry;
import org.apache.jackrabbit.core.session.SessionContext;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.apache.jackrabbit.core.state.XAItemStateManager;
import org.apache.jackrabbit.core.xml.ImportHandler;
import org.apache.jackrabbit.core.xml.WorkspaceImporter;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class WorkspaceImpl
extends AbstractWorkspace
implements JackrabbitWorkspace,
Workspace,
EventStateCollectionFactory {
    private static Logger log = LoggerFactory.getLogger(WorkspaceImpl.class);
    protected final SessionContext context;
    protected final WorkspaceConfig wspConfig;
    protected final LocalItemStateManager stateMgr;
    protected final CachingHierarchyManager hierMgr;
    protected ObservationManagerImpl obsMgr;
    protected QueryManagerImpl queryManager;
    protected final SessionImpl session;
    protected LockManager lockMgr;
    private javax.jcr.lock.LockManager jcr283LockManager;
    protected VersionManagerImpl versionMgr;
    private RetentionRegistry retentionRegistry;

    public WorkspaceImpl(SessionContext context, WorkspaceConfig wspConfig) throws RepositoryException {
        this.context = context;
        this.wspConfig = wspConfig;
        this.stateMgr = this.createItemStateManager();
        this.hierMgr = new CachingHierarchyManager(context.getRootNodeId(), this.stateMgr);
        this.stateMgr.addListener(this.hierMgr);
        this.session = context.getSessionImpl();
    }

    public HierarchyManager getHierarchyManager() {
        return this.hierMgr;
    }

    public LocalItemStateManager getItemStateManager() {
        return this.stateMgr;
    }

    void dispose() {
        if (this.obsMgr != null) {
            this.obsMgr.dispose();
            this.obsMgr = null;
        }
        this.stateMgr.removeListener(this.hierMgr);
        this.stateMgr.dispose();
    }

    public void sanityCheck() throws RepositoryException {
        this.context.getSessionState().checkAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, RepositoryException {
        this.sanityCheck();
        WorkspaceManager manager = this.context.getRepositoryContext().getWorkspaceManager();
        manager.createWorkspace(name);
        SessionImpl tmpSession = null;
        try {
            tmpSession = manager.createSession(this.session.getSubject(), name);
            WorkspaceImpl newWsp = (WorkspaceImpl)tmpSession.getWorkspace();
            Node root = this.getSession().getRootNode();
            NodeIterator it = root.getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                if (tmpSession.nodeExists(child.getPath())) continue;
                newWsp.clone(srcWorkspace, child.getPath(), child.getPath(), false);
            }
        }
        finally {
            if (tmpSession != null) {
                tmpSession.logout();
            }
        }
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        this.context.getRepository().getWorkspaceInfo(name);
        throw new UnsupportedRepositoryOperationException("not yet implemented");
    }

    public javax.jcr.lock.LockManager getLockManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (this.jcr283LockManager == null) {
            this.jcr283LockManager = new SessionLockManager(this.context, this.getInternalLockManager());
        }
        return this.jcr283LockManager;
    }

    public VersionManager getVersionManager() {
        return this.getVersionManagerImpl();
    }

    VersionManagerImpl getVersionManagerImpl() {
        if (this.versionMgr == null) {
            this.versionMgr = new VersionManagerImpl(this.context, this.stateMgr, this.hierMgr);
        }
        return this.versionMgr;
    }

    public void createWorkspace(String name) throws AccessDeniedException, RepositoryException {
        this.sanityCheck();
        this.context.getRepositoryContext().getWorkspaceManager().createWorkspace(name);
    }

    public void createWorkspace(String workspaceName, InputSource configTemplate) throws AccessDeniedException, RepositoryException {
        this.sanityCheck();
        this.context.getRepositoryContext().getWorkspaceManager().createWorkspace(workspaceName, configTemplate);
    }

    public WorkspaceConfig getConfig() {
        return this.wspConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalCopy(String srcAbsPath, WorkspaceImpl srcWsp, String destAbsPath, int flag) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        try {
            srcPath = this.context.getQPath(srcAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + srcAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = this.context.getQPath(destAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + destAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        BatchedItemOperations ops = new BatchedItemOperations(this.stateMgr, this.context);
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        boolean succeeded = false;
        try {
            NodeId id = ops.copy(srcPath, srcWsp.getItemStateManager(), srcWsp.getHierarchyManager(), srcWsp.context.getAccessManager(), destPath, flag);
            ops.update();
            succeeded = true;
            String string = this.context.getJCRPath(this.hierMgr.getPath(id));
            return string;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String internalClone(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, AccessDeniedException, VersionException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        try {
            srcPath = this.context.getQPath(srcAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + srcAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = this.context.getQPath(destAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + destAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        BatchedItemOperations ops = new BatchedItemOperations(this.stateMgr, this.context);
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        boolean succeeded = false;
        try {
            NodeId id = ops.clone(srcPath, destPath);
            ops.update();
            succeeded = true;
            String string = this.context.getJCRPath(this.hierMgr.getPath(id));
            return string;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    public synchronized LockManager getInternalLockManager() throws RepositoryException {
        this.sanityCheck();
        if (this.lockMgr == null) {
            this.lockMgr = this.context.getRepository().getLockManager(this.wspConfig.getName());
            if (this.context.getSessionImpl() instanceof XASessionImpl) {
                this.lockMgr = new XALockManager((LockManagerImpl)this.lockMgr);
            }
        }
        return this.lockMgr;
    }

    synchronized RetentionRegistry getRetentionRegistry() throws RepositoryException {
        this.sanityCheck();
        if (this.retentionRegistry == null) {
            this.retentionRegistry = this.context.getRepository().getRetentionRegistry(this.wspConfig.getName());
        }
        return this.retentionRegistry;
    }

    public String getName() {
        return this.wspConfig.getName();
    }

    public Session getSession() {
        return this.session;
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return this.context.getRepositoryContext().getNamespaceRegistry();
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        this.sanityCheck();
        return this.context.getNodeTypeManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        if (this.getName().equals(srcWorkspace)) {
            if (!removeExisting) {
                this.internalClone(srcAbsPath, destAbsPath);
                return;
            }
            String msg = srcWorkspace + ": illegal workspace (same as current)";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        if (!this.context.getAccessManager().canAccess(srcWorkspace)) {
            throw new AccessDeniedException("not authorized to access " + srcWorkspace);
        }
        SessionImpl srcSession = null;
        try {
            WorkspaceManager manager = this.context.getRepositoryContext().getWorkspaceManager();
            srcSession = manager.createSession(this.session.getSubject(), srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            int mode = 1;
            if (removeExisting) {
                mode = 2;
            }
            this.internalCopy(srcAbsPath, srcWsp, destAbsPath, mode);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        this.internalCopy(srcAbsPath, this, destAbsPath, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        this.sanityCheck();
        if (this.getName().equals(srcWorkspace)) {
            this.copy(srcAbsPath, destAbsPath);
            return;
        }
        if (!this.context.getAccessManager().canAccess(srcWorkspace)) {
            throw new AccessDeniedException("not authorized to access " + srcWorkspace);
        }
        SessionImpl srcSession = null;
        try {
            WorkspaceManager manager = this.context.getRepositoryContext().getWorkspaceManager();
            srcSession = manager.createSession(this.session.getSubject(), srcWorkspace);
            WorkspaceImpl srcWsp = (WorkspaceImpl)srcSession.getWorkspace();
            this.internalCopy(srcAbsPath, srcWsp, destAbsPath, 0);
        }
        finally {
            if (srcSession != null) {
                srcSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        Path destPath;
        Path srcPath;
        this.sanityCheck();
        try {
            srcPath = this.context.getQPath(srcAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + srcAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        if (!srcPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + srcAbsPath);
        }
        try {
            destPath = this.context.getQPath(destAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + destAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        if (!destPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + destAbsPath);
        }
        BatchedItemOperations ops = new BatchedItemOperations(this.stateMgr, this.context);
        try {
            ops.edit();
        }
        catch (IllegalStateException e) {
            String msg = "unable to start edit operation";
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        boolean succeeded = false;
        try {
            ops.move(srcPath, destPath);
            ops.update();
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                ops.cancel();
            }
        }
    }

    public ObservationManager getObservationManager() {
        return this.context.getObservationManager();
    }

    public synchronized QueryManager getQueryManager() throws RepositoryException {
        this.sanityCheck();
        if (this.queryManager == null) {
            SearchManager searchManager;
            try {
                searchManager = this.context.getRepository().getSearchManager(this.wspConfig.getName());
                if (searchManager == null) {
                    String msg = "no search manager configured for this workspace";
                    log.debug(msg);
                    throw new RepositoryException(msg);
                }
            }
            catch (NoSuchWorkspaceException nswe) {
                String msg = "internal error: failed to instantiate query manager";
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)nswe);
            }
            this.queryManager = new QueryManagerImpl(this.context, searchManager);
        }
        return this.queryManager;
    }

    @Deprecated
    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.sanityCheck();
        this.getVersionManager().restore(versions, removeExisting);
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        this.sanityCheck();
        ArrayList<String> names = new ArrayList<String>();
        WorkspaceManager manager = this.context.getRepositoryContext().getWorkspaceManager();
        for (String name : manager.getWorkspaceNames()) {
            try {
                if (!this.context.getAccessManager().canAccess(name)) continue;
                names.add(name);
            }
            catch (NoSuchWorkspaceException e) {
                log.warn("Workspace disappeared unexpectedly: " + name, (Throwable)e);
            }
        }
        return names.toArray(new String[names.size()]);
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        Path parentPath;
        this.sanityCheck();
        try {
            parentPath = this.context.getQPath(parentAbsPath).getNormalizedPath();
        }
        catch (NameException e) {
            String msg = "invalid path: " + parentAbsPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)((Object)e));
        }
        if (!parentPath.isAbsolute()) {
            throw new RepositoryException("not an absolute path: " + parentAbsPath);
        }
        WorkspaceImporter importer = new WorkspaceImporter(parentPath, this, this.context, uuidBehavior, this.wspConfig.getImportConfig());
        return new ImportHandler(importer, this.getSession());
    }

    protected SharedItemStateManager getSharedItemStateManager() throws RepositoryException {
        WorkspaceManager manager = this.context.getRepositoryContext().getWorkspaceManager();
        return manager.getWorkspaceStateManager(this.getName());
    }

    protected LocalItemStateManager createItemStateManager() throws RepositoryException {
        SharedItemStateManager sism = this.getSharedItemStateManager();
        ItemStateCacheFactory iscf = this.context.getRepositoryContext().getItemStateCacheFactory();
        if (this.context.getSessionImpl() instanceof XASessionImpl) {
            return XAItemStateManager.createInstance(sism, this, null, iscf);
        }
        return LocalItemStateManager.createInstance(sism, this, iscf);
    }

    public EventStateCollection createEventStateCollection() throws RepositoryException {
        return ((ObservationManagerImpl)this.getObservationManager()).createEventStateCollection();
    }
}

