/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.jackrabbit;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.testing.jcr.RepositoryProvider;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;

@Component
@Service(value={SlingRepository.class})
public final class JackrabbitMockSlingRepository
implements SlingRepository {
    private SlingRepository delegate;

    @Activate
    protected void activate(ComponentContext componentContext) {
        try {
            this.delegate = RepositoryProvider.instance().getRepository();
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to get jackrabbit SlingRepository instance.", ex);
        }
    }

    public String getDefaultWorkspace() {
        return this.delegate.getDefaultWorkspace();
    }

    public Session loginAdministrative(String workspace) throws LoginException, RepositoryException {
        return this.delegate.loginAdministrative(workspace);
    }

    public Session loginService(String subServiceName, String workspace) throws LoginException, RepositoryException {
        return this.loginAdministrative(workspace);
    }

    public String[] getDescriptorKeys() {
        return this.delegate.getDescriptorKeys();
    }

    public boolean isStandardDescriptor(String key) {
        return this.delegate.isStandardDescriptor(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.delegate.isSingleValueDescriptor(key);
    }

    public Value getDescriptorValue(String key) {
        return this.delegate.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.delegate.getDescriptorValues(key);
    }

    public String getDescriptor(String key) {
        return this.delegate.getDescriptor(key);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegate.login(credentials, workspaceName);
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.delegate.login(credentials);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.delegate.login(workspaceName);
    }

    public Session login() throws LoginException, RepositoryException {
        return this.delegate.login();
    }
}

