/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCommitContextRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(TaskCommitContextRegistry.class);
    private static TaskCommitContextRegistry ourInstance = new TaskCommitContextRegistry();
    private HashMap<String, TaskCommitterProxy> taskCommitters = new HashMap();

    public static TaskCommitContextRegistry getInstance() {
        return ourInstance;
    }

    public synchronized void commitTask(TaskAttemptContext context) throws IOException {
        String key = this.generateKey(context);
        if (!this.taskCommitters.containsKey(key)) {
            throw new IOException("No callback registered for TaskAttemptID:" + key);
        }
        try {
            LOG.info("Committing TaskAttempt:" + key);
            this.taskCommitters.get(key).commitTask(context);
        }
        catch (Throwable t) {
            throw new IOException("Could not clean up TaskAttemptID:" + key, t);
        }
    }

    private String generateKey(TaskAttemptContext context) throws IOException {
        String jobInfoString = context.getConfiguration().get("mapreduce.lib.hcatoutput.info");
        if (StringUtils.isBlank((String)jobInfoString)) {
            throw new IOException("Could not retrieve OutputJobInfo for TaskAttempt " + context.getTaskAttemptID());
        }
        OutputJobInfo jobInfo = (OutputJobInfo)HCatUtil.deserialize(jobInfoString);
        return context.getTaskAttemptID().toString() + "@" + jobInfo.getLocation();
    }

    public synchronized void abortTask(TaskAttemptContext context) throws IOException {
        String key = this.generateKey(context);
        if (!this.taskCommitters.containsKey(key)) {
            throw new IOException("No callback registered for TaskAttemptID:" + key);
        }
        try {
            LOG.info("Aborting TaskAttempt:" + key);
            this.taskCommitters.get(key).abortTask(context);
        }
        catch (Throwable t) {
            throw new IOException("Could not clean up TaskAttemptID:" + key, t);
        }
    }

    public synchronized void register(TaskAttemptContext context, TaskCommitterProxy committer) throws IOException {
        String key = this.generateKey(context);
        LOG.info("Registering committer for TaskAttemptID:" + key);
        if (this.taskCommitters.containsKey(key)) {
            LOG.warn("Replacing previous committer:" + committer);
        }
        this.taskCommitters.put(key, committer);
    }

    public synchronized void discardCleanupFor(TaskAttemptContext context) throws IOException {
        String key = this.generateKey(context);
        LOG.info("Discarding all cleanup for TaskAttemptID:" + key);
        if (!this.taskCommitters.containsKey(key)) {
            LOG.warn("No committer registered for TaskAttemptID:" + key);
        } else {
            this.taskCommitters.remove(key);
        }
    }

    private TaskCommitContextRegistry() {
    }

    public static interface TaskCommitterProxy {
        public void abortTask(TaskAttemptContext var1) throws IOException;

        public void commitTask(TaskAttemptContext var1) throws IOException;
    }
}

