/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.validate.AbstractNamespace;
import org.apache.calcite.sql.validate.SqlModality;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.Static;

public class TableConstructorNamespace
extends AbstractNamespace {
    private final SqlCall values;
    private final SqlValidatorScope scope;

    TableConstructorNamespace(SqlValidatorImpl validator, SqlCall values, SqlValidatorScope scope, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.values = values;
        this.scope = scope;
    }

    @Override
    protected RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.validateValues(this.values, targetRowType, this.scope);
        RelDataType tableConstructorRowType = this.validator.getTableConstructorRowType(this.values, this.scope);
        if (tableConstructorRowType == null) {
            throw this.validator.newValidationError(this.values, Static.RESOURCE.incompatibleTypes());
        }
        return tableConstructorRowType;
    }

    @Override
    public SqlNode getNode() {
        return this.values;
    }

    public SqlValidatorScope getScope() {
        return this.scope;
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        return modality == SqlModality.RELATION;
    }
}

