/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.cgroup;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ClosedByInterruptException;
import org.apache.storm.shade.org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOperation {
    private static final Logger LOG = LoggerFactory.getLogger(SystemOperation.class);

    public static boolean isRoot() throws IOException {
        String result2 = SystemOperation.exec("echo $EUID").substring(0, 1);
        return Integer.valueOf(result2.substring(0, result2.length())) == 0;
    }

    public static void mount(String name, String target, String type, String options) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("mount -t ").append(type).append(" -o ").append(options).append(" ").append(name).append(" ").append(target);
        SystemOperation.exec(sb.toString());
    }

    public static void umount(String pathToDir) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("umount ").append(pathToDir);
        SystemOperation.exec(sb.toString());
    }

    public static String exec(String cmd) throws IOException {
        LOG.debug("Shell cmd: {}", (Object)cmd);
        Process process = new ProcessBuilder("/bin/bash", "-c", cmd).start();
        try {
            process.waitFor();
            String output = IOUtils.toString((InputStream)process.getInputStream());
            String errorOutput = IOUtils.toString((InputStream)process.getErrorStream());
            LOG.debug("Shell Output: {}", (Object)output);
            if (errorOutput.length() != 0) {
                LOG.error("Shell Error Output: {}", (Object)errorOutput);
                throw new IOException(errorOutput);
            }
            return output;
        }
        catch (InterruptedException | ClosedByInterruptException ie) {
            throw new IOException(ie);
        }
    }
}

