/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor;

import com.codahale.metrics.Meter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.storm.daemon.supervisor.ExitCodeCallback;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ShellUtils;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSupervisorUtils {
    public static final Meter numWorkerLaunchExceptions = ShellUtils.numShellExceptions;
    private static final Logger LOG = LoggerFactory.getLogger(ClientSupervisorUtils.class);

    static boolean doRequiredTopoFilesExist(Map<String, Object> conf, String stormId) throws IOException {
        String stormroot = ConfigUtils.supervisorStormDistRoot(conf, stormId);
        String stormcodepath = ConfigUtils.supervisorStormCodePath(stormroot);
        String stormconfpath = ConfigUtils.supervisorStormConfPath(stormroot);
        if (!Utils.checkFileExists(stormroot)) {
            return false;
        }
        if (!Utils.checkFileExists(stormcodepath)) {
            return false;
        }
        if (!Utils.checkFileExists(stormconfpath)) {
            return false;
        }
        String stormjarpath = ConfigUtils.supervisorStormJarPath(stormroot);
        return ConfigUtils.isLocalMode(conf) || Utils.checkFileExists(stormjarpath);
    }

    public static int processLauncherAndWait(Map<String, Object> conf, String user, List<String> args, Map<String, String> environment, String logPreFix) throws IOException {
        return ClientSupervisorUtils.processLauncherAndWait(conf, user, args, environment, logPreFix, null);
    }

    public static int processLauncherAndWait(Map<String, Object> conf, String user, List<String> args, Map<String, String> environment, String logPreFix, File dir) throws IOException {
        int ret = 0;
        Process process = ClientSupervisorUtils.processLauncher(conf, user, null, args, environment, null, null, dir);
        if (StringUtils.isNotBlank((String)logPreFix)) {
            Utils.readAndLogStream(logPreFix, process.getInputStream());
        }
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            LOG.warn("{} interrupted.", (Object)logPreFix);
            Thread.currentThread().interrupt();
            process.destroy();
            throw new IOException(logPreFix + " interrupted", e);
        }
        ret = process.exitValue();
        return ret;
    }

    public static Process processLauncher(Map<String, Object> conf, String user, List<String> commandPrefix, List<String> args, Map<String, String> environment, String logPreFix, ExitCodeCallback exitCodeCallback, File dir) throws IOException {
        if (StringUtils.isBlank((String)user)) {
            throw new IllegalArgumentException("User cannot be blank when calling processLauncher.");
        }
        String wlinitial = (String)conf.get("supervisor.worker.launcher");
        String stormHome = ConfigUtils.concatIfNotNull(System.getProperty("storm.home"));
        Object wl = StringUtils.isNotBlank((String)wlinitial) ? wlinitial : stormHome + "/bin/worker-launcher";
        ArrayList<String> commands = new ArrayList<String>();
        if (commandPrefix != null) {
            commands.addAll(commandPrefix);
        }
        commands.add((String)wl);
        commands.add(user);
        commands.addAll(args);
        LOG.info("Running as user: {} command: {}", (Object)user, commands);
        return ClientSupervisorUtils.launchProcess(commands, environment, logPreFix, exitCodeCallback, dir);
    }

    public static Process launchProcess(List<String> command, Map<String, String> environment, final String logPrefix, final ExitCodeCallback exitCodeCallback, File dir) throws IOException {
        Process process;
        ProcessBuilder builder = new ProcessBuilder(command);
        Map<String, String> procEnv = builder.environment();
        if (dir != null) {
            builder.directory(dir);
        }
        builder.redirectErrorStream(true);
        if (environment != null) {
            procEnv.putAll(environment);
        }
        try {
            process = builder.start();
        }
        catch (IOException e) {
            numWorkerLaunchExceptions.mark();
            throw e;
        }
        if (logPrefix != null || exitCodeCallback != null) {
            Utils.asyncLoop(new Callable<Long>(){

                @Override
                public Long call() {
                    if (logPrefix != null) {
                        Utils.readAndLogStream(logPrefix, process.getInputStream());
                    }
                    if (exitCodeCallback != null) {
                        try {
                            process.waitFor();
                            exitCodeCallback.call(process.exitValue());
                        }
                        catch (InterruptedException ie) {
                            LOG.info("{} interrupted", (Object)logPrefix);
                            exitCodeCallback.call(-1);
                        }
                    }
                    return null;
                }
            });
        }
        return process;
    }

    public static void setupStormCodeDir(Map<String, Object> conf, String user, String dir) throws IOException {
        if (ObjectReader.getBoolean(conf.get("supervisor.run.worker.as.user"), false)) {
            String logPrefix = "Storm Code Dir Setup for " + dir;
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("code-dir");
            commands.add(dir);
            ClientSupervisorUtils.processLauncherAndWait(conf, user, commands, null, logPrefix);
        }
    }

    public static void setupWorkerArtifactsDir(Map<String, Object> conf, String user, String dir) throws IOException {
        if (ObjectReader.getBoolean(conf.get("supervisor.run.worker.as.user"), false)) {
            String logPrefix = "Worker Artifacts Setup for " + dir;
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("artifacts-dir");
            commands.add(dir);
            ClientSupervisorUtils.processLauncherAndWait(conf, user, commands, null, logPrefix);
        }
    }
}

