/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.messaging.TaskMessage;
import org.apache.storm.messaging.netty.BackPressureStatus;
import org.apache.storm.messaging.netty.ControlMessage;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.shade.io.netty.buffer.ByteBuf;
import org.apache.storm.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.storm.shade.io.netty.handler.codec.ByteToMessageDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(MessageDecoder.class);
    private final KryoValuesDeserializer deser;

    public MessageDecoder(KryoValuesDeserializer deser) {
        this.deser = deser;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        long available = buf.readableBytes();
        if (available < 2L) {
            return;
        }
        ArrayList<TaskMessage> ret = new ArrayList<TaskMessage>();
        while (available >= 2L) {
            byte[] bytes;
            int length;
            buf.markReaderIndex();
            short code = buf.readShort();
            available -= 2L;
            ControlMessage controlMessage = ControlMessage.mkMessage(code);
            if (controlMessage != null) {
                if (controlMessage == ControlMessage.EOB_MESSAGE) continue;
                out.add(controlMessage);
                return;
            }
            if (code == -500) {
                if (buf.readableBytes() < 4) {
                    buf.resetReaderIndex();
                    return;
                }
                length = buf.readInt();
                if (length <= 0) {
                    out.add(new SaslMessageToken(null));
                    return;
                }
                if (buf.readableBytes() < length) {
                    buf.resetReaderIndex();
                    return;
                }
                bytes = new byte[length];
                buf.readBytes(bytes);
                out.add(new SaslMessageToken(bytes));
                return;
            }
            if (code == -600) {
                available = buf.readableBytes();
                if (available < 4L) {
                    buf.resetReaderIndex();
                    return;
                }
                int dataLen = buf.readInt();
                if (available < (long)(4 + dataLen)) {
                    buf.resetReaderIndex();
                    return;
                }
                bytes = new byte[dataLen];
                buf.readBytes(bytes);
                out.add(BackPressureStatus.read(bytes, this.deser));
                return;
            }
            if (available < 4L) {
                buf.resetReaderIndex();
                break;
            }
            length = buf.readInt();
            available -= 4L;
            if (length <= 0) {
                ret.add(new TaskMessage(code, null));
                break;
            }
            if (available < (long)length) {
                buf.resetReaderIndex();
                break;
            }
            available -= (long)length;
            bytes = new byte[length];
            buf.readBytes(bytes);
            ret.add(new TaskMessage(code, bytes));
        }
        if (!ret.isEmpty()) {
            out.add(ret);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Exception thrown while decoding messages in channel {}; exception: ", (Object)ctx.channel(), (Object)cause);
        ctx.close();
    }
}

