/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.messaging.netty;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.storm.messaging.netty.SaslMessageToken;
import org.apache.storm.messaging.netty.SaslUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslNettyClient {
    private static final Logger LOG = LoggerFactory.getLogger(SaslNettyClient.class);
    private SaslClient saslClient;

    public SaslNettyClient(String topologyName, byte[] token) {
        try {
            LOG.debug("SaslNettyClient: Creating SASL {} client to authenticate to server ", (Object)"DIGEST-MD5");
            this.saslClient = Sasl.createSaslClient(new String[]{"DIGEST-MD5"}, null, null, "default", SaslUtils.getSaslProps(), new SaslClientCallbackHandler(topologyName, token));
        }
        catch (IOException e) {
            LOG.error("SaslNettyClient: Could not obtain topology token for Netty Client to use to authenticate with a Netty Server.");
            this.saslClient = null;
        }
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    public byte[] saslResponse(SaslMessageToken saslTokenMessage) {
        try {
            return this.saslClient.evaluateChallenge(saslTokenMessage.getSaslToken());
        }
        catch (SaslException e) {
            LOG.error("saslResponse: Failed to respond to SASL server's token:", (Throwable)e);
            return null;
        }
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] userPassword;

        SaslClientCallbackHandler(String topologyToken, byte[] token) {
            this.userName = SaslUtils.encodeIdentifier(topologyToken.getBytes());
            this.userPassword = SaslUtils.encodePassword(token);
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "handle: Unrecognized SASL client callback");
            }
            if (nc != null) {
                LOG.debug("handle: SASL client callback: setting username: {}", (Object)this.userName);
                nc.setName(this.userName);
            }
            if (pc != null) {
                LOG.debug("handle: SASL client callback: setting userPassword");
                pc.setPassword(this.userPassword);
            }
            if (rc != null) {
                LOG.debug("handle: SASL client callback: setting realm: {}", (Object)rc.getDefaultText());
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

