/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.storm.streams.ProcessorNode;
import org.apache.storm.streams.processors.ProcessorContext;

public class ChainedProcessorContext<T>
implements ProcessorContext<T> {
    private final ProcessorNode processorNode;
    private final List<? extends ProcessorContext> contexts;

    public ChainedProcessorContext(ProcessorNode processorNode, List<? extends ProcessorContext> contexts) {
        this.processorNode = processorNode;
        this.contexts = new ArrayList<ProcessorContext>(contexts);
    }

    public ChainedProcessorContext(ProcessorNode processorNode, ProcessorContext ... contexts) {
        this(processorNode, Arrays.asList(contexts));
    }

    @Override
    public void forward(T input) {
        for (ProcessorContext processorContext : this.contexts) {
            processorContext.forward(input);
        }
    }

    @Override
    public void forward(T input, String stream) {
        for (ProcessorContext processorContext : this.contexts) {
            processorContext.forward(input, stream);
        }
    }

    @Override
    public boolean isWindowed() {
        return this.processorNode.isWindowed();
    }

    @Override
    public Set<String> getWindowedParentStreams() {
        return this.processorNode.getWindowedParentStreams();
    }
}

