/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelMetadata;
import org.apache.storm.shade.io.netty.channel.ChannelOutboundBuffer;
import org.apache.storm.shade.io.netty.channel.ChannelPipeline;
import org.apache.storm.shade.io.netty.channel.ChannelPromise;
import org.apache.storm.shade.io.netty.channel.IoRegistration;
import org.apache.storm.shade.io.netty.channel.ServerChannel;
import org.apache.storm.shade.io.netty.channel.unix.Buffer;
import org.apache.storm.shade.io.netty.channel.unix.Errors;
import org.apache.storm.shade.io.netty.channel.uring.AbstractIoUringChannel;
import org.apache.storm.shade.io.netty.channel.uring.IoUring;
import org.apache.storm.shade.io.netty.channel.uring.IoUringIoOps;
import org.apache.storm.shade.io.netty.channel.uring.IoUringRecvByteAllocatorHandle;
import org.apache.storm.shade.io.netty.channel.uring.LinuxSocket;
import org.apache.storm.shade.io.netty.channel.uring.Native;
import org.apache.storm.shade.io.netty.util.internal.CleanableDirectBuffer;

abstract class AbstractIoUringServerChannel
extends AbstractIoUringChannel
implements ServerChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private final AcceptedAddressMemory acceptedAddressMemory = IoUring.isAcceptMultishotEnabled() ? null : new AcceptedAddressMemory();
    private long acceptId;

    protected AbstractIoUringServerChannel(LinuxSocket socket, boolean active) {
        super(null, socket, active);
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected final void doClose() throws Exception {
        super.doClose();
    }

    @Override
    protected final AbstractIoUringChannel.AbstractUringUnsafe newUnsafe() {
        return new UringServerChannelUnsafe();
    }

    @Override
    protected final void doWrite(ChannelOutboundBuffer in) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void cancelOutstandingReads(IoRegistration registration, int numOutstandingReads) {
        if (this.acceptId != 0L) {
            assert (numOutstandingReads == 1 || numOutstandingReads == -1);
            IoUringIoOps ops = IoUringIoOps.newAsyncCancel((byte)0, this.acceptId, (short)13);
            registration.submit(ops);
            this.acceptId = 0L;
        } else assert (numOutstandingReads == 0 || numOutstandingReads == -1);
    }

    @Override
    protected final void cancelOutstandingWrites(IoRegistration registration, int numOutstandingWrites) {
        assert (numOutstandingWrites == 0);
    }

    abstract Channel newChildChannel(int var1, ByteBuffer var2) throws Exception;

    @Override
    protected boolean socketIsEmpty(int flags) {
        return IoUring.isAcceptNoWaitSupported() && IoUring.isCqeFSockNonEmptySupported() && (flags & 4) == 0;
    }

    @Override
    boolean isPollInFirst() {
        return false;
    }

    private final class UringServerChannelUnsafe
    extends AbstractIoUringChannel.AbstractUringUnsafe {
        private UringServerChannelUnsafe() {
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean writeComplete0(byte op, int res, int flags, short data, int outstanding) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int scheduleRead0(boolean first, boolean socketIsEmpty) {
            long acceptedAddressLengthMemoryAddress;
            long acceptedAddressMemoryAddress;
            short ioPrio;
            assert (AbstractIoUringServerChannel.this.acceptId == 0L);
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.attemptedBytesRead(1);
            int fd = AbstractIoUringServerChannel.this.fd().intValue();
            IoRegistration registration = AbstractIoUringServerChannel.this.registration();
            if (IoUring.isAcceptMultishotEnabled()) {
                ioPrio = 1;
                acceptedAddressMemoryAddress = 0L;
                acceptedAddressLengthMemoryAddress = 0L;
            } else {
                ioPrio = IoUring.isAcceptNoWaitSupported() ? (first ? (socketIsEmpty ? (short)4 : 0) : (short)2) : (short)0;
                assert (AbstractIoUringServerChannel.this.acceptedAddressMemory != null);
                acceptedAddressMemoryAddress = AbstractIoUringServerChannel.this.acceptedAddressMemory.acceptedAddressMemoryAddress;
                acceptedAddressLengthMemoryAddress = AbstractIoUringServerChannel.this.acceptedAddressMemory.acceptedAddressLengthMemoryAddress;
            }
            IoUringIoOps ops = IoUringIoOps.newAccept(fd, (byte)0, 0, ioPrio, acceptedAddressMemoryAddress, acceptedAddressLengthMemoryAddress, AbstractIoUringServerChannel.this.nextOpsId());
            AbstractIoUringServerChannel.this.acceptId = registration.submit(ops);
            if (AbstractIoUringServerChannel.this.acceptId == 0L) {
                return 0;
            }
            if ((ioPrio & 1) != 0) {
                return -1;
            }
            return 1;
        }

        @Override
        protected void readComplete0(byte op, int res, int flags, short data, int outstanding) {
            block9: {
                boolean rearm;
                if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                    AbstractIoUringServerChannel.this.acceptId = 0L;
                    return;
                }
                boolean bl = rearm = (flags & 2) == 0;
                if (rearm) {
                    AbstractIoUringServerChannel.this.acceptId = 0L;
                }
                IoUringRecvByteAllocatorHandle allocHandle = (IoUringRecvByteAllocatorHandle)AbstractIoUringServerChannel.this.unsafe().recvBufAllocHandle();
                ChannelPipeline pipeline = AbstractIoUringServerChannel.this.pipeline();
                allocHandle.lastBytesRead(res);
                if (res >= 0) {
                    allocHandle.incMessagesRead(1);
                    ByteBuffer acceptedAddressBuffer = AbstractIoUringServerChannel.this.acceptedAddressMemory == null ? null : AbstractIoUringServerChannel.this.acceptedAddressMemory.acceptedAddressMemory;
                    try {
                        Channel channel = AbstractIoUringServerChannel.this.newChildChannel(res, acceptedAddressBuffer);
                        pipeline.fireChannelRead(channel);
                        if (allocHandle.continueReading() && !AbstractIoUringServerChannel.this.socketIsEmpty(flags)) {
                            if (rearm) {
                                this.scheduleRead(false);
                            }
                            break block9;
                        }
                        allocHandle.readComplete();
                        pipeline.fireChannelReadComplete();
                    }
                    catch (Throwable cause) {
                        allocHandle.readComplete();
                        pipeline.fireChannelReadComplete();
                        pipeline.fireExceptionCaught(cause);
                    }
                } else {
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    if (res != Errors.ERRNO_EAGAIN_NEGATIVE && res != Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
                        pipeline.fireExceptionCaught(Errors.newIOException("io_uring accept", res));
                    }
                }
            }
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            promise.setFailure(new UnsupportedOperationException());
        }

        @Override
        public void unregistered() {
            super.unregistered();
            if (AbstractIoUringServerChannel.this.acceptedAddressMemory != null) {
                AbstractIoUringServerChannel.this.acceptedAddressMemory.free();
            }
        }
    }

    private static final class AcceptedAddressMemory {
        private final CleanableDirectBuffer acceptedAddressMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(Native.SIZEOF_SOCKADDR_STORAGE);
        private final ByteBuffer acceptedAddressMemory = this.acceptedAddressMemoryCleanable.buffer();
        private final CleanableDirectBuffer acceptedAddressLengthMemoryCleanable;
        private final ByteBuffer acceptedAddressLengthMemory;
        private final long acceptedAddressMemoryAddress = Buffer.memoryAddress(this.acceptedAddressMemory);
        private final long acceptedAddressLengthMemoryAddress;

        AcceptedAddressMemory() {
            this.acceptedAddressLengthMemoryCleanable = Buffer.allocateDirectBufferWithNativeOrder(8);
            this.acceptedAddressLengthMemory = this.acceptedAddressLengthMemoryCleanable.buffer();
            this.acceptedAddressLengthMemory.putLong(0, Native.SIZEOF_SOCKADDR_STORAGE);
            this.acceptedAddressLengthMemoryAddress = Buffer.memoryAddress(this.acceptedAddressLengthMemory);
        }

        void free() {
            this.acceptedAddressMemoryCleanable.clean();
            this.acceptedAddressLengthMemoryCleanable.clean();
        }
    }
}

