/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metrics2.PerReporterGauge;
import org.apache.storm.metrics2.WorkerMetricRegistrant;
import org.apache.storm.task.IBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;

public class SystemBolt
implements IBolt {
    private static final long MIN_CPU_CALCULATION_THRESHOLD_NSEC = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    private static boolean prepareWasCalled = false;

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        if (prepareWasCalled && !"local".equals(topoConf.get("storm.cluster.mode"))) {
            throw new RuntimeException("A single worker should have 1 SystemBolt instance.");
        }
        prepareWasCalled = true;
        context.registerMetricSet("GC", (MetricSet)new GarbageCollectorMetricSet());
        context.registerMetricSet("threads", (MetricSet)new ThreadStatesGaugeSet());
        context.registerMetricSet("memory", (MetricSet)new MemoryUsageGaugeSet());
        final RuntimeMXBean jvmRt = ManagementFactory.getRuntimeMXBean();
        context.registerGauge("uptimeSecs", new Gauge<Long>(){

            public Long getValue() {
                return jvmRt.getUptime() / 1000L;
            }
        });
        context.registerGauge("startTimeSecs", new Gauge<Long>(){

            public Long getValue() {
                return jvmRt.getStartTime() / 1000L;
            }
        });
        context.registerGauge("newWorkerEvent", new NewWorkerGauge());
        context.registerGauge("workerCpuUsage", new WorkerCpuMetric());
        int bucketSize = ObjectReader.getInt(topoConf.get("topology.builtin.metrics.bucket.size.secs"));
        this.registerMetrics(context, (Map)topoConf.get("worker.metrics"), bucketSize, topoConf);
        this.registerMetrics(context, (Map)topoConf.get("topology.worker.metrics"), bucketSize, topoConf);
    }

    private void registerMetrics(TopologyContext context, Map<String, String> metrics, int bucketSize, Map<String, Object> conf) {
        if (metrics == null) {
            return;
        }
        for (Map.Entry<String, String> metric : metrics.entrySet()) {
            try {
                Object workerMetric = ReflectionUtils.newInstance(metric.getValue(), conf);
                if (workerMetric instanceof IMetric) {
                    context.registerMetric(metric.getKey(), (IMetric)workerMetric, bucketSize);
                    continue;
                }
                if (workerMetric instanceof WorkerMetricRegistrant) {
                    ((WorkerMetricRegistrant)workerMetric).registerMetrics(context);
                    continue;
                }
                throw new RuntimeException("Invalid worker metric " + String.valueOf(workerMetric));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void execute(Tuple input) {
        throw new RuntimeException("Non-system tuples should never be sent to __system bolt.");
    }

    @Override
    public void cleanup() {
    }

    private class NewWorkerGauge
    extends PerReporterGauge<Integer> {
        private final NewWorkerMetric defaultValue;
        private final Map<Object, NewWorkerMetric> reporterValues;

        private NewWorkerGauge() {
            this.defaultValue = new NewWorkerMetric();
            this.reporterValues = new HashMap<Object, NewWorkerMetric>();
        }

        public Integer getValue() {
            return this.defaultValue.getValueAndReset();
        }

        @Override
        public Integer getValueForReporter(Object reporter) {
            return this.reporterValues.computeIfAbsent(reporter, rep -> new NewWorkerMetric()).getValueAndReset();
        }
    }

    private class WorkerCpuMetric
    implements Gauge<Double> {
        private long lastCalculationTimeNsec = System.nanoTime();
        private long previousCpuTotal = this.getTotalCpuUsage();
        private double cpuUsage = 0.0;

        WorkerCpuMetric() {
        }

        private long getTotalCpuUsage() {
            long totalCpuNsecs = 0L;
            ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
            long[] lArray = threadMxBean.getAllThreadIds();
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long threadId = lArray[i];
                long threadCpu = threadMxBean.getThreadCpuTime(threadId);
                if (threadCpu <= 0L) continue;
                totalCpuNsecs += threadCpu;
            }
            return totalCpuNsecs;
        }

        private void updateCalculation() {
            long elapsed = System.nanoTime() - this.lastCalculationTimeNsec;
            if (elapsed >= MIN_CPU_CALCULATION_THRESHOLD_NSEC) {
                long cpuUsage = this.getTotalCpuUsage();
                long usageDuringPeriod = cpuUsage - this.previousCpuTotal;
                this.cpuUsage = (double)usageDuringPeriod / (double)elapsed;
                this.lastCalculationTimeNsec = System.nanoTime();
                this.previousCpuTotal = cpuUsage;
            }
        }

        public Double getValue() {
            this.updateCalculation();
            return this.cpuUsage;
        }
    }

    private class NewWorkerMetric {
        boolean newWorker = true;

        private NewWorkerMetric() {
        }

        public int getValueAndReset() {
            if (this.newWorker) {
                this.newWorker = false;
                return 1;
            }
            return 0;
        }
    }
}

