/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.sasl;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;

public class SimpleSaslClientCallbackHandler
implements CallbackHandler {
    private final String username;
    private final String password;

    public SimpleSaslClientCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback c : callbacks) {
            if (c instanceof NameCallback) {
                NameCallback nc = (NameCallback)c;
                nc.setName(this.username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)c;
                if (this.password == null) continue;
                pc.setPassword(this.password.toCharArray());
                continue;
            }
            if (c instanceof AuthorizeCallback) {
                String authzid;
                AuthorizeCallback ac = (AuthorizeCallback)c;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (!ac.isAuthorized()) continue;
                ac.setAuthorizedID(authzid);
                continue;
            }
            if (c instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)c;
                ((RealmCallback)c).setText(rc.getDefaultText());
                continue;
            }
            throw new UnsupportedCallbackException(c);
        }
    }
}

