/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.state.CombinerValueUpdater;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.state.ValueUpdater;
import org.apache.storm.trident.state.map.MapState;
import org.apache.storm.trident.tuple.ComboList;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class MapCombinerAggStateUpdater
implements StateUpdater<MapState> {
    private static final long serialVersionUID = -3960578785572592092L;
    CombinerAggregator agg;
    Fields groupFields;
    Fields inputFields;
    transient TridentTupleView.ProjectionFactory groupFactory;
    transient TridentTupleView.ProjectionFactory inputFactory;
    ComboList.Factory factory;

    public MapCombinerAggStateUpdater(CombinerAggregator agg, Fields groupFields, Fields inputFields) {
        this.agg = agg;
        this.groupFields = groupFields;
        this.inputFields = inputFields;
        if (inputFields.size() != 1) {
            throw new IllegalArgumentException("Combiner aggs only take a single field as input. Got this instead: " + inputFields.toString());
        }
        this.factory = new ComboList.Factory(groupFields.size(), inputFields.size());
    }

    @Override
    public void updateState(MapState map, List<TridentTuple> tuples, TridentCollector collector) {
        ArrayList<List<Object>> groups = new ArrayList<List<Object>>(tuples.size());
        ArrayList<ValueUpdater> updaters = new ArrayList<ValueUpdater>(tuples.size());
        for (TridentTuple t : tuples) {
            groups.add(this.groupFactory.create(t));
            updaters.add(new CombinerValueUpdater(this.agg, this.inputFactory.create(t).getValue(0)));
        }
        List newVals = map.multiUpdate(groups, updaters);
        for (int i = 0; i < tuples.size(); ++i) {
            List key = (List)groups.get(i);
            Object result2 = newVals.get(i);
            collector.emit(this.factory.create(new List[]{key, new Values(result2)}));
        }
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentOperationContext context) {
        this.groupFactory = context.makeProjectionFactory(this.groupFields);
        this.inputFactory = context.makeProjectionFactory(this.inputFields);
    }

    @Override
    public void cleanup() {
    }
}

