/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleVersion
implements Comparable<SimpleVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)[\\.\\-\\_]+(\\d+).*$");
    private final int major;
    private final int minor;

    public SimpleVersion(String version) {
        Matcher m = VERSION_PATTERN.matcher(version);
        int maj = -1;
        int min = -1;
        if (!m.matches()) {
            if (!"Unknown".equals(version)) {
                throw new IllegalArgumentException("Cannot parse '" + version + "'");
            }
        } else {
            maj = Integer.valueOf(m.group(1));
            min = Integer.valueOf(m.group(2));
        }
        this.major = maj;
        this.minor = min;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int hashCode() {
        return Integer.hashCode(this.major) * 17 & Integer.hashCode(this.minor);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleVersion)) {
            return false;
        }
        return this.compareTo((SimpleVersion)o) == 0;
    }

    @Override
    public int compareTo(SimpleVersion o) {
        int ret = Integer.compare(this.major, o.major);
        if (ret == 0) {
            ret = Integer.compare(this.minor, o.minor);
        }
        return ret;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }
}

