/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.Locale;

class NetUtil {
    static final int DEFAULT_TCP_BACKLOG_WINDOWS = 200;
    static final int DEFAULT_TCP_BACKLOG_LINUX = 128;
    static final Path TCP_BACKLOG_SETTING_LOCATION = Path.of("/proc/sys/net/core/somaxconn", new String[0]);

    NetUtil() {
    }

    public static int getTcpBacklog() {
        return NetUtil.getTcpBacklog(NetUtil.getDefaultTcpBacklog());
    }

    static int getTcpBacklog(int tcpBacklog) {
        return AccessController.doPrivileged(() -> {
            try {
                return Integer.parseInt(Files.readAllLines(TCP_BACKLOG_SETTING_LOCATION, StandardCharsets.US_ASCII).get(0).trim());
            }
            catch (IOException | NullPointerException | NumberFormatException | SecurityException e) {
                return tcpBacklog;
            }
        });
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
    }

    private static int getDefaultTcpBacklog() {
        return NetUtil.isWindows() ? 200 : 128;
    }
}

