/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.util.Arrays;
import org.apache.storm.shade.io.netty.channel.uring.MsgHdrMemory;

final class MsgHdrMemoryArray {
    static final long NO_ID = 0L;
    private final MsgHdrMemory[] hdrs;
    private final int capacity;
    private final long[] ids;
    private boolean released;
    private int idx;

    MsgHdrMemoryArray(short capacity) {
        assert (capacity >= 0);
        this.capacity = capacity;
        this.hdrs = new MsgHdrMemory[capacity];
        this.ids = new long[capacity];
        for (int i = 0; i < this.hdrs.length; ++i) {
            this.hdrs[i] = new MsgHdrMemory((short)i);
            this.ids[i] = 0L;
        }
    }

    boolean isFull() {
        return this.idx == this.hdrs.length;
    }

    MsgHdrMemory nextHdr() {
        if (this.isFull()) {
            return null;
        }
        return this.hdrs[this.idx++];
    }

    void restoreNextHdr(MsgHdrMemory hdr) {
        assert (hdr.idx() == this.idx - 1);
        --this.idx;
    }

    MsgHdrMemory hdr(int idx) {
        return this.hdrs[idx];
    }

    long id(int idx) {
        return this.ids[idx];
    }

    void setId(int idx, long id) {
        this.ids[idx] = id;
    }

    void clear() {
        Arrays.fill(this.ids, 0, this.idx, 0L);
        this.idx = 0;
    }

    int length() {
        return this.idx;
    }

    void release() {
        assert (!this.released);
        this.released = true;
        for (MsgHdrMemory hdr : this.hdrs) {
            hdr.release();
        }
    }

    int capacity() {
        return this.capacity;
    }
}

